<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializable\Model\CustomAttributes;

/**
 * Converts custom attributes to the format that will be serialized
 */
class CustomAttributeConverter
{
    /**
     * Converts array of custom attributes to the format that will be serialized
     *
     * @param array $customAttributes
     * @return array
     */
    public function toSerializableFormat(array $customAttributes): array
    {
        $attributes = [];
        foreach ($customAttributes as $attribute) {
            if (!empty($attribute->getValue()) || $attribute->getValue() === '0' || $attribute->getValue() === 0) {
                $attributes[$attribute->getAttributeCode()] = $attribute->getValue();
            }
        }

        return $attributes;
    }
}
