<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Test\Api;

use Magento\Framework\Api\AttributeValue;

/**
 * Converts array of custom attributes to the format for GraphQL query
 */
class AttributesToQueryConverter
{
    /**
     * Converts array of custom attributes to the format for GraphQL query
     *
     * @param array $attributes
     * @return string
     */
    public function convert(array $attributes): string
    {
        $convertedCustomAttributes = [];
        foreach ($attributes as $attributeCode => $value) {
            if ($value instanceof AttributeValue) {
                $convertedCustomAttributes[] = [
                    'attribute_code' => $value->getAttributeCode(),
                    'value' => $value->getValue()
                ];
            } else {
                $convertedCustomAttributes[] = [
                    'attribute_code' => $attributeCode,
                    'value' => $value
                ];
            }
        }

        return strtr(
            json_encode($convertedCustomAttributes),
            [
                '"attribute_code"' => 'attribute_code',
                '"value"' => 'value',
            ]
        );
    }
}
