<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Test\Api\Quote;

use Magento\CustomAttributeSerializableGraphQl\Test\Api\AttributesToQueryConverter;

/**
 * Contains the query for adding custom attributes to cart and cart items.
 */
class QueryHelper
{
    /**
     * @param AttributesToQueryConverter $attributesToQueryConverter
     */
    public function __construct(private AttributesToQueryConverter $attributesToQueryConverter)
    {
    }

    /**
     * Returns GraphQL query for adding custom attributes to cart item.
     *
     * @param string $maskedCartId
     * @param string $itemUid
     * @param array $customAttributes
     * @return string
     */
    public function getCustomAttributesOnCartItemMutationQuery(
        string $maskedCartId,
        string $itemUid,
        array $customAttributes
    ): string {
        return <<<QUERY
mutation {
  setCustomAttributesOnCartItem(
    input: {
      cart_id: "{$maskedCartId}",
      cart_item_id: "{$itemUid}",
      custom_attributes: {$this->attributesToQueryConverter->convert($customAttributes)}
    }
  ), {
    cart {
      itemsV2 {
        items {
          custom_attributes {
            attribute_code
            value
          }
          product {
            sku
            country_of_manufacture
          }
          quantity
          uid
        }
      }
    }
  }
}
QUERY;
    }

    /**
     * Returns the query for adding custom attributes to cart.
     *
     * @param string $maskedCartId
     * @param array $customAttributes
     * @return string
     */
    public function getCustomAttributesOnCartMutationQuery(string $maskedCartId, array $customAttributes): string
    {
        return <<<QUERY
mutation {
  setCustomAttributesOnCart(
    input: {
      cart_id: "{$maskedCartId}",
      custom_attributes: {$this->attributesToQueryConverter->convert($customAttributes)}
    }
  ), {
    cart {
      custom_attributes {
        attribute_code
        value
      }
      itemsV2 {
          items {
            product {
              sku
              country_of_manufacture
            }
            quantity
            uid
          }
      }
    }
  }
}
QUERY;
    }
}
