<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Test\Api\CreditMemo;

use Magento\CustomAttributeSerializableGraphQl\Test\Api\AttributesToQueryConverter;

/**
 * Contains GraphQl queries for getting and setting custom attributes for credit memo and credit memo items
 */
class QueryHelper
{
    /**
     * @param AttributesToQueryConverter $attributesToQueryConverter
     */
    public function __construct(private readonly AttributesToQueryConverter $attributesToQueryConverter)
    {
    }

    /**
     * Returns a query for fetching an order with a credit memo and credit memo items
     */
    public function getOrderWithCreditMemoAndCreditMemoItems(string $orderNumber): string
    {
        return <<<QUERY
{
  customer {
     orders(filter: {number: {eq: "{$orderNumber}"}}) {
       items {
         credit_memos {
           id
           custom_attributes {
             attribute_code
             value
           }
           items {
             id
             custom_attributes {
               attribute_code
               value
             }
           }
         }
       }
     }
  }
}
QUERY;
    }

    /**
     * Returns a query for adding custom attributes to a credit memo
     *
     * @param string $creditMemoId
     * @param array $customAttributes
     * @return string
     */
    public function getCustomAttributesOnCreditMemoMutationQuery(string $creditMemoId, array $customAttributes): string
    {
        return <<<QUERY
mutation {
  setCustomAttributesOnCreditMemo(
    input: {
      credit_memo_id: "{$creditMemoId}",
      custom_attributes: {$this->attributesToQueryConverter->convert($customAttributes)}
    }
  ), {
    credit_memo {
      id
      custom_attributes {
        attribute_code
        value
      }
      items {
        id
        custom_attributes {
          attribute_code
          value
        }
      }
    }
  }
}
QUERY;
    }

    /**
     * Returns a query for adding custom attributes to a credit memo item
     *
     * @param string $creditMemoId
     * @param string $creditMemoItemId
     * @param array $customAttributes
     * @return string
     */
    public function getCustomAttributesOnCreditMemoItemMutationQuery(
        string $creditMemoId,
        string $creditMemoItemId,
        array $customAttributes
    ): string {
        return <<<QUERY
mutation {
  setCustomAttributesOnCreditMemoItem(
    input: {
      credit_memo_id: "{$creditMemoId}",
      credit_memo_item_id: "{$creditMemoItemId}",
      custom_attributes: {$this->attributesToQueryConverter->convert($customAttributes)}
    }
  ), {
    credit_memo {
      id
      custom_attributes {
        attribute_code
        value
      }
      items {
        id
        custom_attributes {
          attribute_code
          value
        }
      }
    }
  }
}
QUERY;
    }
}
