<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Model\Resolver\Invoice\Item;

use Magento\CustomAttributeSerializableGraphQl\Model\CustomAttributesToOutputConverter;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\Resolver\Value;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Psr\Log\LoggerInterface;

/**
 * Resolver for custom attributes field of invoice item
 */
class CustomAttributes implements ResolverInterface
{
    /**
     * @param CustomAttributesToOutputConverter $customAttributesToOutputConverter
     * @param LoggerInterface $logger
     */
    public function __construct(
        private readonly CustomAttributesToOutputConverter $customAttributesToOutputConverter,
        private readonly LoggerInterface $logger,
    ) {
    }

    /**
     * Return information about custom attributes for invoice item
     *
     * @param Field            $field
     * @param ContextInterface $context
     * @param ResolveInfo      $info
     * @param array|null       $value
     * @param array|null       $args
     *
     * @return array|Value|mixed
     * @throws GraphQlInputException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        ?array $value = null,
        ?array $args = null
    ) {
        try {
            $invoiceItem = $value['model'];

            return $this->customAttributesToOutputConverter->convert($invoiceItem->getCustomAttributes());
        } catch (LocalizedException $e) {
            $this->logger->error(__('Can\'t load custom attributes for the invoice with id %1', $value['id']));

            return null;
        }
    }
}
