<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Model\Resolver\Invoice;

use Magento\Sales\Api\Data\InvoiceInterface;

/**
 * Create invoice response
 */
class InvoiceResponse
{
    /**
     * Create invoice response
     *
     * @param InvoiceInterface $invoice
     * @return array
     */
    public function create(InvoiceInterface $invoice): array
    {
        return [
            'invoice' => [
                'id' => base64_encode((string)$invoice->getEntityId()),
                'number' => $invoice['increment_id'],
                'comments' => $this->getInvoiceComments($invoice),
                'model' => $invoice,
                'order' => $invoice->getOrder()
            ],
        ];
    }

    /**
     * Get invoice comments in proper format
     *
     * @param InvoiceInterface $invoice
     * @return array
     */
    private function getInvoiceComments(InvoiceInterface $invoice): array
    {
        $comments = [];
        foreach ($invoice->getComments() as $comment) {
            if ($comment->getIsVisibleOnFront()) {
                $comments[] = [
                    'timestamp' => $comment->getCreatedAt(),
                    'message' => $comment->getComment()
                ];
            }
        }
        return $comments;
    }
}
