<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Model\Resolver;

use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\Uid;

/**
 * Validates input arguments for invoice and invoice item set attributes resolvers
 */
class InputArgumentValidator
{
    /**
     * @param Uid $uidEncoder
     */
    public function __construct(private readonly Uid $uidEncoder)
    {
    }

    /**
     * Validates input arguments
     *
     * @param array $args
     * @param array $requiredFields
     * @param array $base64Fields
     * @return void
     * @throws GraphQlInputException
     */
    public function validate(array $args, array $requiredFields, array $base64Fields = []): void
    {
        foreach ($requiredFields as $field) {
            if (empty($args[$field])) {
                throw new GraphQlInputException(__('Required parameter "%1" is missing', $field));
            }
        }

        foreach ($base64Fields as $field) {
            if (!$this->uidEncoder->isValidBase64($args[$field])) {
                throw new GraphQlInputException(__('Required parameter "%1" has a wrong format', $field));
            }
        }

        if (empty($args['custom_attributes']) || !is_array($args['custom_attributes'])) {
            throw new GraphQlInputException(__('Required parameter "custom_attributes" is missing'));
        }
    }
}
