<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\CustomAttributeSerializableGraphQl\Test\Api\Invoice;

use Magento\CustomAttributeSerializableGraphQl\Test\Api\AttributesToQueryConverter;

/**
 * Contains the query for adding custom attributes to invoice and invoice items.
 */
class QueryHelper
{
    /**
     * @param AttributesToQueryConverter $attributesToQueryConverter
     */
    public function __construct(private AttributesToQueryConverter $attributesToQueryConverter)
    {
    }

    /**
     * Returns the query for adding custom attributes to invoice item.
     *
     * @param string $invoiceId
     * @param string $invoiceItemId
     * @param array $customAttributes
     * @return string
     */
    public function getCustomAttributesOnInvoiceItemMutationQuery(
        string $invoiceId,
        string $invoiceItemId,
        array $customAttributes
    ): string  {
        return <<<QUERY
mutation {
  setCustomAttributesOnInvoiceItem(
     input: {
       invoice_id: "{$invoiceId}",
       invoice_item_id: "{$invoiceItemId}",
       custom_attributes: {$this->attributesToQueryConverter->convert($customAttributes)}
     }

  ), {
     invoice {
       id
       custom_attributes {
         attribute_code
         value
       }
       items {
         id
         custom_attributes {
           attribute_code
           value
         }
       }
   }
  }
}
QUERY;
    }

    /**
     * Returns the query for adding custom attributes to invoice.
     *
     * @param string $invoiceId
     * @param array $customAttributes
     * @return string
     */
    public function getCustomAttributesOnInvoiceMutationQuery(string $invoiceId, array $customAttributes): string
    {
        return <<<QUERY
mutation {
  setCustomAttributesOnInvoice(
     input: {
       invoice_id: "{$invoiceId}",
       custom_attributes: {$this->attributesToQueryConverter->convert($customAttributes)}
     }
  ), {
     invoice {
       id
       custom_attributes {
         attribute_code
         value
       }
       items {
         id
         custom_attributes {
           attribute_code
           value
         }
       }
   }
  }
}
QUERY;
    }

    /**
     * Returns the query for getting order with invoice and invoice items.
     *
     * @param string $orderNumber
     * @return string
     */
    public function getOrderWithInvoiceAndInvoiceItems(string $orderNumber): string
    {
        return <<<QUERY
{
  customer {
     orders(filter: {number: {eq: "{$orderNumber}"}}) {
       items {
         invoices {
           id
           custom_attributes {
             attribute_code
             value
           }
           items {
             id
             custom_attributes {
               attribute_code
               value
             }
           }
         }
         id
         order_date
       }
     }
  }
}
QUERY;
    }
}
