<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/** @var \Magento\Framework\ObjectManagerInterface $objectManager */
$objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();

/** @var \Magento\Framework\Registry $registry */
$registry = $objectManager->get(\Magento\Framework\Registry::class);
$registry->unregister('isSecureArea');
$registry->register('isSecureArea', true);

/** @var \Magento\Catalog\Api\ProductRepositoryInterface $productInterface */
$productInterface = $objectManager->create(\Magento\Catalog\Api\ProductRepositoryInterface::class);

$product = $productInterface->get('simple_option_50');
if ($product->getId()) {
    $productInterface->delete($product);
}

$product = $productInterface->get('simple_option_60');
if ($product->getId()) {
    $productInterface->delete($product);
}

$product = $productInterface->get('simple_option_70');
if ($product->getId()) {
    $productInterface->delete($product);
}

$product = $productInterface->get('configurable1');
if ($product->getId()) {
    $productInterface->delete($product);
}

$registry->unregister('isSecureArea');
$registry->register('isSecureArea', false);

require __DIR__ . '/setup_configurable_attribute_rollback.php';
require __DIR__ . '/../../../../CatalogDataExporter/Test/Integration/_files/setup_categories_rollback.php';
require __DIR__ . '/../../../../CatalogDataExporter/Test/Integration/_files/setup_stores_rollback.php';
