<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */

/**
 * Request data interface
 */
namespace Magento\Config\Model\Config\Backend\File\RequestData;

/**
 * @api
 * @since 100.0.2
 */
interface RequestDataInterface
{
    /**
     * Retrieve uploaded file tmp name by path
     *
     * @param string $path
     * @return string
     */
    public function getTmpName($path);

    /**
     * Retrieve uploaded file name by path
     *
     * @param string $path
     * @return string
     */
    public function getName($path);
}
