<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\CmsSampleDataVenia\Setup\Patch\Data;

use Magento\Cms\Helper\Page;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class UpdateDefaultData implements DataPatchInterface
{
    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resource;

    /**
     * @param \Magento\Framework\App\ResourceConnection $resource
     */
    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource
    ) {
        $this->resource = $resource;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        // Update core config
        $this->updateCmsHomePageConfig('venia-new-home');
    }

    /**
     * Update the CMS pages content
     *
     * @param $title
     * @param $content
     */
    public function updateCmsPageContent($title, $content)
    {
        $this->resource->getConnection()->update('cms_page', ['content' => $content], ['title = ?' => $title]);
    }

    /**
     * Update a CMS blocks content
     *
     * @param $identifier
     * @param $content
     */
    public function updateCmsBlockContent($identifier, $content)
    {
        $this->resource->getConnection()->update('cms_block', ['content' => $content], ['identifier = ?' => $identifier]);
    }

    /**
     * Update a CMS home page config
     *
     * @param $value
     */
    public function updateCmsHomePageConfig($value)
    {
        $count = $this->resource->getConnection()->update('core_config_data', ['value' => $value], ['path = ?' => Page::XML_PATH_HOME_PAGE]);
        if ($count < 1) {
            $data = [
                'scope' => 'default',
                'scope_id' => 0,
                'path' => Page::XML_PATH_HOME_PAGE,
                'value' => $value,
            ];
            $this->resource->getConnection()->insert('core_config_data', $data);
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
