<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Magento\CmsSampleDataVenia\Setup\Patch\Data;

use Magento\Framework\Setup;
use Magento\Framework\Setup\Patch\DataPatchInterface;

/**
 * Class InstallCmsSampleData
 * @package Magento\CmsSampleDataVenia\Setup\Patch\Data
 */
class InstallCmsSampleData implements DataPatchInterface
{
    /**
     * @var Setup\SampleData\Executor
     */
    protected $executor;

    /**
     * @var \Magento\CmsSampleDataVenia\Setup\Installer
     */
    protected $installer;

    /**
     * InstallCmsSampleData constructor.
     * @param Setup\SampleData\Executor $executor
     * @param \Magento\CmsSampleDataVenia\Setup\Installer $installer
     */
    public function __construct(
        Setup\SampleData\Executor $executor,
        \Magento\CmsSampleDataVenia\Setup\Installer $installer
    ) {
        $this->executor = $executor;
        $this->installer = $installer;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $this->executor->exec($this->installer);
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
