/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define(
    [
        'ko',
        'jquery',
        'uiComponent',
        'Magento_CheckoutAgreements/js/model/agreements-modal'
    ],
    function (ko, $, Component, agreementsModal) {
        'use strict';
        var checkoutConfig = window.checkoutConfig,
            agreementManualMode = 1,
            agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};

        return Component.extend({
            defaults: {
                template: 'Magento_CheckoutAgreements/checkout/checkout-agreements'
            },
            isVisible: agreementsConfig.isEnabled,
            agreements: agreementsConfig.agreements,
            modalTitle: ko.observable(null),
            modalContent: ko.observable(null),
            modalWindow: null,

            /**
             * Checks if agreement required
             *
             * @param element
             */
            isAgreementRequired: function(element) {
                return element.mode == agreementManualMode;
            },

            /**
             * Show agreement content in modal
             *
             * @param element
             */
            showContent: function (element) {
                this.modalTitle(element.checkboxText);
                this.modalContent(element.content);
                agreementsModal.showModal();
            },

            /**
             * build a unique id for the term checkbox
             *
             * @param {Object} context - the ko context
             * @param {Number} agreementId
             */
            getCheckboxId: function (context, agreementId) {
                var paymentMethodName = '',
                    paymentMethodRenderer = context.$parents[1];

                // corresponding payment method fetched from parent context
                if (paymentMethodRenderer) {
                    // item looks like this: {title: "Check / Money order", method: "checkmo"}
                    paymentMethodName = paymentMethodRenderer.item ?
                      paymentMethodRenderer.item.method : '';
                }

                return 'agreement_' + paymentMethodName + '_' + agreementId;
            },

            /**
             * Init modal window for rendered element
             *
             * @param element
             */
            initModal: function(element) {
                agreementsModal.createModal(element);
            }
        });
    }
);
