/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',
    'underscore',
    'mageUtils'
], function (DynamicRows, _, utils) {
    'use strict';

    return DynamicRows.extend({
        defaults: {
            mappingSettings: {
                enabled: false,
                distinct: false
            },
            update: true,
            map: {
                'option_id': 'option_id'
            },
            identificationProperty: 'option_id',
            identificationDRProperty: 'option_id'
        },

        /**
         * Cleans options' values from IDs because otherwise wrong IDs will be assigned.
         *
         * @param {Array} values
         * @private
         */
        __cleanOptionValuesUp: function (values) {
            values.each(function (value) {
                delete value['option_id'];
                delete value['option_type_id'];
            });
        },

        /** @inheritdoc */
        processingInsertData: function (data) {
            var options = [],
                currentOption,
                self = this;

            if (!data) {
                return;
            }
            data.each(function (item) {
                if (!item.options) {
                    return;
                }
                item.options.each(function (option) {
                    currentOption = utils.copy(option);

                    if (currentOption.hasOwnProperty('sort_order')) {
                        delete currentOption['sort_order'];
                    }

                    if (currentOption.hasOwnProperty('option_id')) {
                        delete currentOption['option_id'];
                    }

                    if (currentOption.values.length > 0) {
                        self.__cleanOptionValuesUp(currentOption.values);
                    }
                    options.push(currentOption);
                });
            });

            if (!options.length) {
                return;
            }
            this.cacheGridData = options;
            options.each(function (opt) {
                this.mappingValue(opt);
            }, this);

            this.insertData([]);
        },

        /**
         * Set empty array to dataProvider
         */
        clearDataProvider: function () {
            this.source.set(this.dataProvider, []);
        },

        /** @inheritdoc */
        processingAddChild: function (ctx, index, prop) {
            if (!ctx) {
                this.showSpinner(true);
                this.addChild(ctx, index, prop);

                return;
            }

            this._super(ctx, index, prop);
        },

        /**
         * Mutes parent method
         */
        updateInsertData: function () {
            return false;
        }
    });
});
