<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * Adminhtml block for fieldset of product custom options
 */
namespace Magento\Catalog\Block\Adminhtml\Product\Composite\Fieldset;

class Qty extends \Magento\Framework\View\Element\Template
{
    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        array $data = []
    ) {
        $this->_coreRegistry = $registry;
        parent::__construct($context, $data);
    }

    /**
     * Constructor for our block with options
     *
     * @return void
     */
    public function _construct()
    {
        parent::_construct();
        $this->setIsLastFieldset(true);
    }

    /**
     * Retrieve product
     *
     * @return \Magento\Catalog\Model\Product
     */
    public function getProduct()
    {
        if (!$this->hasData('product')) {
            $this->setData('product', $this->_coreRegistry->registry('product'));
        }
        $product = $this->getData('product');

        return $product;
    }

    /**
     * Return selected qty
     *
     * @return int
     */
    public function getQtyValue()
    {
        $qty = $this->getProduct()->getPreconfiguredValues()->getQty();
        if (!$qty) {
            $qty = 1;
        }
        return $qty;
    }
}
