<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\CatalogUrlRewrite\Test\Unit\Model\Category\Plugin;

use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Magento\UrlRewrite\Model\StorageInterface;
use Magento\CatalogUrlRewrite\Model\Category\Plugin\Storage as CategoryStoragePlugin;
use Magento\UrlRewrite\Service\V1\Data\UrlRewrite;
use Magento\UrlRewrite\Model\UrlFinderInterface;
use Magento\CatalogUrlRewrite\Model\Category\Product;
use Magento\CatalogUrlRewrite\Model\ResourceModel\Category\Product as ProductResourceModel;

/**
 * Tests CategoryStoragePlugin class.
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class StorageTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var CategoryStoragePlugin
     */
    private $plugin;

    /**
     * @var UrlFinderInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $urlFinder;

    /**
     * @var StorageInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $storage;

    /**
     * @var Product|\PHPUnit_Framework_MockObject_MockObject
     */
    private $product;

    /**
     * @var ProductResourceModel|\PHPUnit_Framework_MockObject_MockObject
     */
    private $productResourceModel;

    /**
     * @var UrlRewrite|\PHPUnit_Framework_MockObject_MockObject
     */
    private $urlRewrite;

    protected function setUp()
    {
        $this->storage = $this->getMockBuilder(StorageInterface::class)
            ->getMockForAbstractClass();
        $this->urlFinder = $this->getMockBuilder(UrlFinderInterface::class)
            ->getMockForAbstractClass();
        $this->product = $this->getMockBuilder(Product::class)
            ->disableOriginalConstructor()
            ->getMock();
        $this->productResourceModel = $this->getMockBuilder(ProductResourceModel::class)
            ->disableOriginalConstructor()
            ->getMock();
        $this->urlRewrite = $this->getMockBuilder(UrlRewrite::class)
            ->disableOriginalConstructor()
            ->setMethods(['getMetadata', 'getEntityType', 'getIsAutogenerated', 'getUrlRewriteId', 'getEntityId'])
            ->getMock();

        $this->plugin = (new ObjectManager($this))->getObject(
            CategoryStoragePlugin::class,
            [
                'urlFinder' => $this->urlFinder,
                'productResource' => $this->productResourceModel
            ]
        );
    }

    /**
     * Covers afterReplace() method.
     *
     * @return void
     */
    public function testAroundReplace()
    {
        $this->urlRewrite->expects(static::any())->method('getMetadata')->willReturn(['category_id' => '5']);
        $this->urlRewrite->expects(static::once())->method('getEntityTYpe')->willReturn('product');
        $this->urlRewrite->expects(static::once())->method('getIsAutogenerated')->willReturn(1);
        $this->urlRewrite->expects(static::once())->method('getUrlRewriteId')->willReturn('4');
        $this->urlRewrite->expects(static::once())->method('getEntityId')->willReturn('2');
        $this->urlRewrite->setData('request_path', 'test');
        $this->urlRewrite->setData('store_id', '1');
        $productUrls = ['targetPath' => $this->urlRewrite];

        $this->urlFinder->expects(static::once())->method('findAllByData')->willReturn([$this->urlRewrite]);

        $this->productResourceModel->expects(static::once())->method('saveMultiple')->willReturnSelf();

        $className = 'Magento\UrlRewrite\Model\StorageInterface';
        /** @var \Magento\SalesRule\Model\Rule|\PHPUnit_Framework_MockObject_MockObject $subject */
        $subject = $this->getMock($className, [], [], '', false);
        $closureMock = function () use ($subject) {
            return $subject;
        };

        $this->plugin->aroundReplace($this->storage, $closureMock, $productUrls);
    }

    /**
     * Covers beforeDeleteByData() method.
     *
     * @return void
     */
    public function testBeforeDeleteByData()
    {
        $data = [1, 2, 3];
        $this->productResourceModel->expects(static::once())
            ->method('removeMultipleByProductCategory')
            ->with($data)->willReturnSelf();
        $this->plugin->beforeDeleteByData($this->storage, $data);
    }
}
