<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\CatalogInventoryDataExporter\Test\Integration;

use Magento\CatalogDataExporter\Test\Integration\AbstractProductTestHelper;
use Magento\TestFramework\Helper\Bootstrap;

class ProductLowStockTest extends AbstractProductTestHelper
{

    /**
     * Load fixtures for test
     */
    public static function loadFixture()
    {
        include __DIR__ . '/_files/setup_is_low_stock.php';
    }

    /**
     * Remove fixtures
     */
    public static function tearDownAfterClass()
    {
        include __DIR__ . '/_files/setup_is_low_stock_rollback.php';
    }

    /**
     * Validate lowStock status
     *
     * @magentoDbIsolation disabled
     * @magentoAppIsolation enabled
     * @magentoDataFixture loadFixture
     * @magentoConfigFixture current_store cataloginventory/options/stock_threshold_qty 20
     * @return void
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Zend_Db_Statement_Exception
     */
    public function testProductLowStock() : void
    {
        $sku = 'simple6';
        $storeViewCode = 'default';

        $this->runIndexer();
        $this->changeLowStockStatus($sku);
        $this->runIndexer();

        $extractedProduct = $this->getExtractedProduct($sku, $storeViewCode);
        $this->validateProductLowStock($extractedProduct);
    }

    /**
     * Change lowStock status of product
     *
     * @param string $sku
     * @return void
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Exception
     */
    protected function changeLowStockStatus(string $sku) : void
    {
        /** @var \Magento\Catalog\Api\ProductRepositoryInterface $productInterface */
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $productInterface = $objectManager->create(\Magento\Catalog\Api\ProductRepositoryInterface::class);
        $product = $productInterface->get($sku);
        $productId = $product->getId();

        /** @var \Magento\CatalogInventory\Model\Stock\Item $stockItem */
        $stockItem = Bootstrap::getObjectManager()->create(\Magento\CatalogInventory\Model\Stock\Item::class);
        $stockItem->load($productId, 'product_id');
        $stockItem->setQty(1);
        $stockItem->save();
    }

    /**
     * Validate lowStock status of product in extracted product data
     *
     * @param array $extractedProduct
     * @return void
     */
    protected function validateProductLowStock(array $extractedProduct) : void
    {
        $this->assertEquals(true, $extractedProduct['feedData']['lowStock']);
    }
}
