<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

use Magento\Catalog\Model\Entity\Attribute;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Attribute\Set;
use Magento\Eav\Model\Entity\Type;
use Magento\Framework\ObjectManagerInterface;
use Magento\TestFramework\Helper\Bootstrap;

/** @var ObjectManagerInterface $objectManager */
$objectManager = Bootstrap::getObjectManager();

/** @var Set $attributeSet */
$attributeSet = $objectManager->create(Set::class);
$attributeSet->load('SaaSCatalogAttributeSet', 'attribute_set_name');

if (!$attributeSet->getId()) {
    /** @var Set $attributeSet */
    $attributeSet = $objectManager->create(Set::class);

    /** @var Type $entityType */
    $entityType = $objectManager->create(Type::class)->loadByCode('catalog_product');
    $defaultSetId = $objectManager->create(Product::class)->getDefaultAttributeSetid();

    $data = [
        'attribute_set_name' => 'SaaSCatalogAttributeSet',
        'entity_type_id' => $entityType->getId(),
        'sort_order' => 300,
    ];

    $attributeSet->setData($data);
    $attributeSet->validate();
    $attributeSet->save();
    $attributeSet->initFromSkeleton($defaultSetId);
    $attributeSet->save();

    $attributeSetInfo = [
        'entity_type_id' => $entityType->getId(),
        'attribute_set_id' => $attributeSet->getId(),
        'attribute_group_id' => $attributeSet->getDefaultGroupId()
    ];

    $attributesDefinitions = [
        'custom_label' => [
            'attribute_code' => 'custom_label',
            'frontend_input' => 'text',
            'backend_type' => 'varchar',
            'is_required' => 0,
            'is_user_defined' => 1,
        ],
        'custom_description' => [
            'attribute_code' => 'custom_description',
            'frontend_input' => 'text',
            'backend_type' => 'text',
            'is_required' => 0,
            'is_user_defined' => 1,
        ]
    ];

    foreach ($attributesDefinitions as $attributesDefinition) {
        /** @var Attribute $attribute */
        $attributeData = array_merge($attributesDefinition, $attributeSetInfo);
        $attribute = $objectManager->create(Attribute::class);
        $attribute->setData($attributeData);
        $attribute->save();
    }
}
