<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/** @var \Magento\Framework\ObjectManagerInterface $objectManager */
$objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();

/** @var \Magento\Store\Model\Store $store */
$store = $objectManager->create(\Magento\Store\Model\Store::class);
if (!$store->load('fixture_second_store', 'code')->getId()) {
    $websiteId = $objectManager->get(\Magento\Store\Model\StoreManagerInterface::class)
        ->getWebsite()
        ->getId();
    $groupId =$objectManager->get(\Magento\Store\Model\StoreManagerInterface::class)->getWebsite()->getDefaultGroupId();
    $store->setCode('fixture_second_store')->setWebsiteId($websiteId)
        ->setGroupId($groupId)
        ->setName('Fixture Store')
        ->setSortOrder(10)
        ->setIsActive(1);
    $store->save();
}
