<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/** @var \Magento\Framework\ObjectManagerInterface $objectManager */
$objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();

/** @var \Magento\Framework\Registry $registry */
$registry = $objectManager->get(\Magento\Framework\Registry::class);
$registry->unregister('isSecureArea');
$registry->register('isSecureArea', true);

try {
    /** @var \Magento\Catalog\Api\ProductRepositoryInterface $productInterface */
    $productInterface = $objectManager->create(\Magento\Catalog\Api\ProductRepositoryInterface::class);
    $product = $productInterface->get('simple4');
    if ($product->getId()) {
        $productInterface->delete($product);
    }
} catch (\Exception $e) {
    // Nothing to delete
}

$registry->unregister('isSecureArea');
$registry->register('isSecureArea', false);
