<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/** @var \Magento\Eav\Model\Entity\Attribute\Set $attributeSet */
$attributeSet = $objectManager->create(\Magento\Eav\Model\Entity\Attribute\Set::class);

/** @var \Magento\Eav\Model\Entity\Type $entityType */
$entityType = $objectManager->create(\Magento\Eav\Model\Entity\Type::class)->loadByCode('catalog_product');
$defaultSetId = $objectManager->create(\Magento\Catalog\Model\Product::class)->getDefaultAttributeSetid();

$data = [
    'attribute_set_name' => 'SaaSCatalogAttributeSet',
    'entity_type_id' => $entityType->getId(),
    'sort_order' => 300,
];

$attributeSet->setData($data);
$attributeSet->validate();
$attributeSet->save();
$attributeSet->initFromSkeleton($defaultSetId);
$attributeSet->save();

$attributeSetInfo = [
    'entity_type_id' => $entityType->getId(),
    'attribute_set_id' => $attributeSet->getId(),
    'attribute_group_id' => $attributeSet->getDefaultGroupId()
];

$attributesDefinitions = [
    'custom_label' => [
        'attribute_code' => 'custom_label',
        'frontend_input' => 'text',
        'backend_type' => 'varchar',
        'is_required' => 0,
        'is_user_defined' => 1,
    ],
    'custom_description' => [
        'attribute_code' => 'custom_description',
        'frontend_input' => 'text',
        'backend_type' => 'text',
        'is_required' => 0,
        'is_user_defined' => 1,
    ]
];

foreach ($attributesDefinitions as $attributesDefinition) {
    /** @var \Magento\Catalog\Model\Entity\Attribute $attribute */
    $attributeData = array_merge($attributesDefinition, $attributeSetInfo);
    $attribute = $objectManager->create(\Magento\Catalog\Model\Entity\Attribute::class);
    $attribute->setData($attributeData);
    $attribute->save();
}
