<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\CatalogDataExporter\Test\Integration;

class ProductRemovalTest extends AbstractProductTestHelper
{

    /**
     * Load fixtures for test
     */
    public static function loadFixture()
    {
        include __DIR__ . '/_files/setup_product_removal.php';
    }

    /**
     * Remove fixtures
     */
    public static function tearDownAfterClass()
    {
        include __DIR__ . '/_files/setup_product_removal_rollback.php';
    }

    /**
     * Validate product removal
     *
     * @magentoDbIsolation disabled
     * @magentoAppIsolation enabled
     * @magentoDataFixture loadFixture
     *
     * @return void
     * @throws \Zend_Db_Statement_Exception
     */
    public function testProductRemoval() : void
    {
        $sku = 'simple4';
        $storeViewCode = 'default';

        $this->runIndexer();
        $this->deleteProduct($sku);
        $this->runIndexer();

        $extractedProduct = $this->getExtractedProduct($sku, $storeViewCode);
        $this->validateProductRemoval($extractedProduct);
    }

    /**
     * Delete product from catalog_data_exporter_products
     *
     * @param string $sku
     * @return void
     */
    protected function deleteProduct(string $sku) : void
    {
        /** @var \Magento\Catalog\Api\ProductRepositoryInterface $productInterface */
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        /** @var \Magento\Framework\Registry $registry */
        $registry = $objectManager->get(\Magento\Framework\Registry::class);
        $registry->unregister('isSecureArea');
        $registry->register('isSecureArea', true);

        try {
            $productInterface = $objectManager->create(\Magento\Catalog\Api\ProductRepositoryInterface::class);
            $product = $productInterface->get($sku);
            if ($product->getId()) {
                $productInterface->delete($product);
            }
        } catch (\Exception $e) {
            //Nothing to delete
        }

        $registry->unregister('isSecureArea');
        $registry->register('isSecureArea', false);
    }

    /**
     * Validate product removal in extracted product data
     *
     * @param array $extractedProduct
     * @return void
     */
    protected function validateProductRemoval(array $extractedProduct) : void
    {
        $this->assertEquals(1, $extractedProduct['is_deleted']);
    }
}
