<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\CatalogDataExporter\Model\Provider\Product;

use Magento\CatalogDataExporter\Model\Query\ProductParentQuery;
use Magento\Framework\App\ResourceConnection;

class Parents
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var ProductParentQuery
     */
    private $productParentQuery;

    /**
     * Prices constructor.
     * @param ResourceConnection $resourceConnection
     * @param ProductParentQuery $productParentQuery
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        ProductParentQuery $productParentQuery
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->productParentQuery = $productParentQuery;
    }

    /**
     * @param array $row
     * @return array
     */
    private function format(array $row) : array
    {
        $output = $row;
        $output['parents'] = [
            'sku' => $row['sku'],
            'productType' => $row['productType']
        ];
        return $output;
    }

    /**
     * @param array $values
     * @return array
     */
    public function get(array $values) : array
    {
        $queryArguments = [];
        foreach ($values as $value) {
            $queryArguments['productId'][$value['productId']] = $value['productId'];
        }
        $output = [];
        try {
            $connection = $this->resourceConnection->getConnection();
            $select = $this->productParentQuery->getQuery($queryArguments);
            $cursor = $connection->query($select);
            while ($row = $cursor->fetch()) {
                $output[] = $this->format($row);
            }
        } catch (\Exception $exception) {
            $this->logger->error($exception->getMessage());
            throw new UnableRetrieveData(__('Unable to retrieve parent product data'));
        }
        return $output;
    }
}
