<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\CatalogDataExporter\Model\Provider\Product;

/**
 * Class Buyable
 */
class Buyable
{
    /**
     * @param array $values
     * @return array
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function get(array $values) : array
    {
        $output = [];
        foreach ($values as $value) {
            $output[] = [
                'productId' => $value['productId'],
                'storeViewCode' => $value['storeViewCode'],
                'buyable' => ($value['status'] == 'Enabled')
            ];
        }
        return $output;
    }
}
