<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */

namespace Magento\Bundle\Model\Sales\Order\Plugin;

/**
 * Plugin to calculate bundle item qty available for cancel
 */
class Item
{
    /**
     * Retrieve item qty available for cancel
     *
     * @param \Magento\Sales\Model\Order\Item $subject
     * @param float|integer $result
     * @return float|integer
     */
    public function afterGetQtyToCancel(\Magento\Sales\Model\Order\Item $subject, $result)
    {
        if ($subject->getProductType() === \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE || $subject->getParentItem()
            && $subject->getParentItem()->getProductType() === \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE
        ) {
            $qtyToCancel = $this->getQtyToCancelBundle($subject);
            return max($qtyToCancel, 0);
        }
        return $result;
    }

    /**
     * Retrieve item qty available for ship
     *
     * @param \Magento\Sales\Model\Order\Item $subject
     * @param float|integer $result
     * @return bool
     */
    public function afterIsProcessingAvailable(\Magento\Sales\Model\Order\Item $subject, $result)
    {
        if ($subject->getProductType() === \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE || $subject->getParentItem()
            && $subject->getParentItem()->getProductType() === \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE
        ) {
            return $subject->getSimpleQtyToShip() > $subject->getQtyToCancel();
        }
        return $result;
    }

    /**
     * Retrieve Bundle child item qty available for cancel
     * getQtyToShip() always returns 0 for BundleItems that ship together
     *
     * @param \Magento\Sales\Model\Order\Item $item
     * @return float|integer
     */
    private function getQtyToCancelBundle($item)
    {
        if ($item->isDummy(true)) {
            return min($item->getQtyToInvoice(), $item->getSimpleQtyToShip());
        }
        return min($item->getQtyToInvoice(), $item->getQtyToShip());
    }
}
