# Overview

## **It's non-official module yet. Just for alpha testing!**

Magento_Baler module introduces functionality to preload theme JS bundles configuration (core-bundle.js & requirejs-bundle-config.js) generated by [Baler](https://github.com/magento/baler/) - tool for static analysis of Javascript dependencies.  
This functionality is disabled by default and it can be enabled on the configuration page (Stores -> Configuration -> Advanced -> Developer -> Javascript Settings).  
Developer settings is not displayed in production mode. To enable this feature in production mode, the CLI command `bin/magento config:set dev/js/enable_baler_js_bundling 1` can be used.

### What is not implemented in this module yet:
1. The following features should be disabled when Magento_Baler is enabled:
   - JS Bundling
   - JS Minification
   
### How to install module

#### Using Git
1. Clone repository: `git clone https://github.com/adifucan/m2-baler.git`
2. Rename cloned `m2-baler` directory into `Baler` and place this directory into `app/code/Magento` directory
3. Run `bin/magento setup:upgrade`

#### Using Composer
1. Add `"magento/module-baler": "dev-master"` to `require` section of `composer.json`  
So, your `require` section looks like:
````
    "require": {
        "magento/product-community-edition": "2.3.3",
        "magento/module-baler": "dev-master"
    },
````
2. Change `"minimum-stability": "stable"` to `"minimum-stability": "dev"` and add `"prefer-stable": true`  
This means that composer will always use stable package unless there is one. If there is no stable package it will use dev version.
3. Add
````
{
    "type": "git",
    "url": "https://github.com/adifucan/m2-baler.git"
}
````
to `requires` section. So it looks like:
````
    "repositories": [
        {
            "type": "composer",
            "url": "https://repo.magento.com/"
        },
        {
            "type": "git",
            "url": "https://github.com/adifucan/m2-baler.git"
        }
    ],
````
4. Run `composer update`
5. `magento/module-baler` should be created in `vendor` folder.

### How to start with Baler
[Getting started with the alpha](https://github.com/magento/baler/blob/master/docs/ALPHA.md)

If you found a bug in this module, please [open a new issue](https://github.com/magento/m2-baler/issues/new) or refer to [Code Of Conduct](.github/CODE_OF_CONDUCT.md).
