<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);

namespace Magento\AuthorizenetAcceptjs\Model\Ui;

use Magento\AuthorizenetAcceptjs\Gateway\Config;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Quote\Api\Data\CartInterface;

/**
 * Retrieves config needed for checkout
 *
 * @deprecated Starting from Magento 2.2.11 Authorize.net payment method core integration is deprecated in favor of
 * official payment integration available on the marketplace
 */
class ConfigProvider implements ConfigProviderInterface
{
    /**
     * @var Config
     */
    private $config;

    /**
     * @var CartInterface
     */
    private $cart;

    /**
     * @var string
     */
    private static $methodCode = 'authorizenet_acceptjs';

    /**
     * @param Config $config
     * @param CartInterface $cart
     */
    public function __construct(Config $config, CartInterface $cart)
    {
        $this->config = $config;
        $this->cart = $cart;
    }

    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $storeId = $this->cart->getStoreId();

        return [
            'payment' => [
                self::$methodCode => [
                    'clientKey' => $this->config->getClientKey($storeId),
                    'apiLoginID' => $this->config->getLoginId($storeId),
                    'environment' => $this->config->getEnvironment($storeId),
                    'useCvv' => $this->config->isCvvEnabled($storeId),
                ]
            ]
        ];
    }
}
