<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\AdobeIoEvents\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class Environment implements OptionSourceInterface
{
    public const ENV_PRODUCTION = 'production';
    public const ENV_STAGING = 'staging';

    /**
     * @return array[]
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::ENV_PRODUCTION, 'label' => __('Production')],
            ['value' => self::ENV_STAGING, 'label' => __('Staging')]
        ];
    }
}
