<?php

namespace Magento\AdobeIoEvents\Model\Data\AdobeConsoleConfiguration;

class AdobeConsoleConfiguration
{
    private Project $project;

    /**
     * Return Project
     *
     * @return Project
     */
    public function getProject(): Project
    {
        return $this->project;
    }

    /**
     * Set Project
     *
     * @param Project $project
     */
    public function setProject(Project $project): void
    {
        $this->project = $project;
    }

    /**
     * Return first set of Credentials
     *
     * @return Credentials|null
     */
    public function getFirstCredential(): ?Credentials
    {
        $credentials = $this->project->getWorkspace()->getDetails()->getCredentials();
        if (array_key_exists(0, $credentials)) {
            return ($this->project->getWorkspace()->getDetails()->getCredentials())[0];
        }
        return null;
    }
}
