<?php

namespace Magento\AdobeIoEvents\Model\Data;

use JsonSerializable;
use Magento\AdobeIoEvents\Api\EventMetadataInterface;

class EventMetadata implements JsonSerializable, EventMetadataInterface
{
    /**
     * @var string
     */
    private string $eventCode;

    /**
     * @var string
     */
    private string $label;

    /**
     * @var string
     */
    private string $description;

    /**
     * Serialize to JSON
     *
     * @return string[]
     */
    public function jsonSerialize(): array
    {
        return [
            "event_code" => $this->getEventCode(),
            "label" => $this->getLabel(),
            "description" => $this->getDescription()
        ];
    }

    /**
     * Return Event Code
     *
     * @return string
     */
    public function getEventCode(): string
    {
        return $this->eventCode;
    }

    /**
     * Set Event Code
     *
     * @param string $eventCode
     */
    public function setEventCode(string $eventCode): void
    {
        $this->eventCode = $eventCode;
    }

    /**
     * Return Description
     *
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * Set Description
     *
     * @param string $description
     */
    public function setDescription(string $description): void
    {
        $this->description = $description;
    }

    /**
     * Represent as String
     *
     * @return string
     */
    public function __toString(): string
    {
        return sprintf("%s (%s) %s", $this->getLabel(), $this->getEventCode(), $this->getDescription());
    }

    /**
     * Return Label
     *
     * @return string
     */
    public function getLabel(): string
    {
        return $this->label;
    }

    /**
     * Set Label
     *
     * @param string $label
     */
    public function setLabel(string $label): void
    {
        $this->label = $label;
    }
}
