<?php

namespace Magento\AdobeIoEvents\Model\Data\AdobeConsoleConfiguration;

class AdobeConsoleConfiguration
{
    private Project $project;

    /**
     * Return Project
     *
     * @return Project
     */
    public function getProject(): Project
    {
        return $this->project;
    }

    /**
     * Set Project
     *
     * @param Project $project
     */
    public function setProject(Project $project): void
    {
        $this->project = $project;
    }

    /**
     * Return first set of Credentials
     *
     * @return Credentials
     */
    public function getFirstCredential(): Credentials
    {
        return ($this->project->getWorkspace()->getDetails()->getCredentials())[0];
    }
}
