<?php

namespace Magento\AdobeIoEvents\Console;

use Magento\AdobeIoEvents\Model\Data\AdobeConsoleConfiguration\ConfigurationFactory;
use Magento\AdobeIoEvents\Model\Data\PrivateKeyFactory;
use Magento\AdobeIoEvents\Model\JwtAccessToken;
use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Exception\AuthorizationException;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\RuntimeException;
use Magento\Framework\Filesystem\File\ReadFactory;
use Magento\Framework\Serialize\Serializer\Json;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CreateEventProvider extends AbstractJwtAuthConsole
{
    public const COMMAND_NAME = "events:create-event-provider";
    /**
     * @var \Magento\AdobeIoEvents\Model\CreateEventProvider
     */
    private \Magento\AdobeIoEvents\Model\CreateEventProvider $createProvider;

    /**
     * @var JwtAccessToken
     */
    private JwtAccessToken $jwtAccessToken;

    /**
     * @param \Magento\AdobeIoEvents\Model\CreateEventProvider $createProvider
     * @param JwtAccessToken $jwtAccessToken
     * @param Json $json
     * @param ConfigurationFactory $configurationFactory
     * @param ReadFactory $readFactory
     * @param PrivateKeyFactory $privateKeyFactory
     */
    public function __construct(
        \Magento\AdobeIoEvents\Model\CreateEventProvider $createProvider,
        JwtAccessToken $jwtAccessToken,
        Json $json,
        ConfigurationFactory $configurationFactory,
        ReadFactory $readFactory,
        PrivateKeyFactory $privateKeyFactory
    ) {
        $this->createProvider = $createProvider;
        $this->jwtAccessToken = $jwtAccessToken;

        parent::__construct($privateKeyFactory, $readFactory, $json, $configurationFactory);
    }

    protected function configure()
    {
        $this->setName(self::COMMAND_NAME);
        $this->setDescription("Create a custom event provider in IO events for this instance.");

        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return void
     * @throws AlreadyExistsException
     * @throws AuthorizationException
     * @throws FileSystemException
     * @throws InputException
     * @throws RuntimeException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $privateKey = $this->getPrivateKey($input);
        $configuration = $this->getConfiguration($input);

        $token = $this->jwtAccessToken->getAccessToken($configuration, $privateKey);

        $this->createProvider->execute($configuration, $token, $output);
    }
}
