/**
 * Copyright 2014 Adobe
 * All Rights Reserved.
 */

/**
 * @api
 */
define([
    'jquery',
    'mage/template',
    'jquery/ui',
    'Magento_Ui/js/modal/modal'
], function ($, mageTemplate) {
    'use strict'; // eslint-disable-line strict

    $.widget('mage.systemMessageDialog', $.mage.modal, {
        options: {
            modalClass: 'modal-system-messages',
            systemMessageTemplate:
                '<% _.each(data.items, function(item) { %>' +
                    '<li class="message message-warning' +
                        '<% if (item.severity == 1) { %>error<% } else { %>warning<% } %>">' +
                        '<%= item.text %>' +
                    '</li>' +
                '<% }); %>'
        },

        /** @inheritdoc */
        _create: function () {
            this.options.title = $('#message-system-all').attr('title');
            this._super();
        },

        /** @inheritdoc */
        openModal: function (severity) {
            var superMethod = $.proxy(this._super, this);

            $.ajax({
                url: this.options.ajaxUrl,
                type: 'GET',
                data: {
                    severity: severity
                }
            }).done($.proxy(function (data) {
                var tmpl = mageTemplate(this.options.systemMessageTemplate, {
                    data: {
                        items: data
                    }
                });

                tmpl = $(tmpl);

                this.element.html(
                    $('<ul></ul>', {
                        'class': 'message-system-list'
                    }).append(tmpl)
                ).trigger('contentUpdated');

                superMethod();
            }, this));

            return this;
        },

        /** @inheritdoc */
        closeModal: function () {
            this._super();
        }
    });

    $(function () {
        $('#system_messages .message-system-short .error').on('click', function () {
            $('#message-system-all').systemMessageDialog('openModal', 1);
        });

        $('#system_messages .message-system-short .warning').on('click', function () {
            $('#message-system-all').systemMessageDialog('openModal', 2);
        });
    });

    return $.mage.systemMessageDialog;
});
