<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

/* These classes are skipped completely during comparison. */
return [
    'navigationMenu' => [
        Magento\CatalogGraphQl\Model\Resolver\Products\DataProvider\ExtractDataFromCategoryTree::class => null,
        Magento\Customer\Model\Session::class => null,
        Magento\Framework\GraphQl\Query\Fields::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\Framework\Module\Manager::class => null,
    ],
    'productDetailByName' => [
        Magento\Customer\Model\Session::class => null,
        Magento\Framework\GraphQl\Query\Fields::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Store\Model\GroupRepository::class => null,
    ],
    'category' => [
        Magento\CatalogGraphQl\Model\Resolver\Products\DataProvider\ExtractDataFromCategoryTree::class => null,
        Magento\Framework\GraphQl\Query\Fields::class => null,
    ],
    'productDetail' => [
        Magento\Framework\GraphQl\Query\Fields::class => null,
    ],
    'resolveUrl' => [
        Magento\Framework\GraphQl\Query\Fields::class => null,
    ],
    'createCustomer' => [
        Magento\Framework\Logger\LoggerProxy::class => null,
        Magento\Framework\View\Asset\PreProcessor\Helper\Sort::class => null,
        Magento\Framework\Filter\FilterManager::class => null,
        Magento\Store\Model\Address\Renderer::class => null,
        Magento\Customer\Model\CustomerRegistry::class => null,
        Magento\Eav\Model\ResourceModel\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\VersionControl\Metadata::class => null,
        Magento\Customer\Model\ResourceModel\Address\Relation::class => null,
        Magento\Framework\Validator\Factory::class => null,
        Magento\Customer\Model\ResourceModel\Address::class => null,
        Magento\Framework\Translate\Inline\ConfigInterface\Proxy::class => null,
        Magento\Framework\Translate\Inline::class => null,
        Magento\Framework\Json\Helper\Data::class => null,
        Magento\Directory\Helper\Data::class => null,
        Magento\TestFramework\Api\Config\Reader\FileResolver::class => null,
        Magento\Framework\Api\ExtensionAttribute\JoinProcessor::class => null,
        Magento\Customer\Model\ResourceModel\AddressRepository::class => null,
        Magento\Framework\Reflection\MethodsMap::class => null,
        Magento\Framework\Reflection\ExtensionAttributesProcessor\Proxy::class => null,
        Magento\Framework\Reflection\DataObjectProcessor::class => null,
        Magento\Framework\Api\DataObjectHelper::class => null,
        Magento\Customer\Model\AttributeMetadataConverter::class => null,
        Magento\Customer\Model\Metadata\CustomerMetadata::class => null,
        Magento\Customer\Model\Metadata\AttributeMetadataCache::class => null,
        Magento\Customer\Model\Metadata\CustomerCachedMetadata::class => null,
        Magento\Customer\Model\Config\Share::class => null,
        Magento\Customer\Model\ResourceModel\Customer::class => null,
        Magento\Framework\Api\ImageProcessor::class => null,
        Magento\Customer\Model\Session\Proxy::class => null,
        Magento\Customer\Model\Delegation\Storage::class => null,
        Magento\Customer\Model\GroupRegistry::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Metadata::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot::class => null,
        Magento\Tax\Model\TaxClass\Repository::class => null,
        Magento\Customer\Model\ResourceModel\GroupRepository::class => null,
        Magento\Customer\Model\ResourceModel\CustomerRepository::class => null,
        Magento\TestFramework\Mail\Template\TransportBuilderMock::class => null,
        Magento\Customer\Helper\View::class => null,
        Magento\Framework\Indexer\IndexerRegistry::class => null,
        Magento\Customer\Model\Customer::class => null,
        Magento\Framework\Session\SessionMaxSizeConfig::class => null,
        Magento\Framework\Session\SaveHandler::class => null,
        Magento\Paypal\Plugin\TransparentSessionChecker::class => null,
        Laminas\Uri\Uri::class => null,
        Magento\Backend\App\Area\FrontNameResolver::class => null,
        Magento\Backend\Helper\Data::class => null,
        Magento\GraphQl\Plugin\DisableSession::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Customer\Model\Session\SessionCleaner::class => null,
        Magento\Customer\Model\Authorization\CustomerSessionUserContext::class => null,
        Magento\JwtUserToken\Model\ResourceModel\FastStorageRevokedWrapper::class => null,
        Magento\Webapi\Model\Authorization\TokenUserContext::class => null,
        Magento\Authorization\Model\CompositeUserContext::class => null,
        Magento\Webapi\Model\WebapiRoleLocator::class => null,
        Magento\Customer\Model\Authentication::class => null,
        'CustomerAddressSnapshot' => null,
        'EavVersionControlSnapshot' => null,
        Magento\Catalog\Helper\Product\Flat\Indexer::class => null,
        Magento\Catalog\Helper\Product::class => null,
        Magento\Framework\Url\Helper\Data::class => null,
        Magento\Customer\Model\Session::class => null,
        Magento\Framework\Validator\EmailAddress::class => null,
        Magento\CustomerGraphQl\Model\Customer\ValidateCustomerData\ValidateEmail::class => null,
        Magento\CustomerGraphQl\Model\Customer\ValidateCustomerData::class => null,
        Magento\Newsletter\Model\CustomerSubscriberCache::class => null,
        Magento\Newsletter\Model\SubscriptionManager::class => null,
        Magento\LoginAsCustomerAssistance\Model\IsAssistanceEnabled::class => null,
        Magento\Framework\MessageQueue\Code\Generator\Config\RemoteServiceReader\Communication::class => null,
        Magento\Framework\Webapi\ServiceInputProcessor::class => null,
        Magento\Framework\MessageQueue\Publisher\Config\RemoteService\Reader::class => null,
        Magento\Framework\Pricing\Helper\Data::class => null,
        Magento\Catalog\Helper\Category::class => null,
        Magento\Catalog\Helper\Data::class => null,
        Magento\Tax\Helper\Data::class => null,
        Magento\Weee\Helper\Data::class => null,
        Magento\Quote\Model\Quote\Address\Total\Collector::class => null,
        Magento\Catalog\Helper\Product\Configuration::class => null,
        Magento\Bundle\Helper\Catalog\Product\Configuration::class => null,
        Magento\Eav\Model\AttributeDataFactory::class => null,
        Magento\PageCache\Model\Cache\Server::class => null,
        Magento\Catalog\Helper\Product\Edit\Action\Attribute::class => null,
        Magento\Newsletter\Model\Plugin\CustomerPlugin::class => null,
        Magento\Newsletter\Helper\Data::class => null,
        Magento\Developer\Helper\Data::class => null,
        Magento\Wishlist\Plugin\SaveWishlistDataAndAddReferenceKeyToBackUrl::class => null,
        Magento\Framework\View\Page\Config\Generator\Head::class => null,
        Magento\Store\Model\Argument\Interpreter\ServiceUrl::class => null,
        Magento\Framework\View\Layout\Argument\Interpreter\Url::class => null,
        Magento\Framework\Css\PreProcessor\Adapter\CssInliner::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\Framework\Module\Manager::class => null,
        Magento\Authorization\Model\UserContextInterface\Proxy::class => null,
        Magento\Catalog\Controller\Adminhtml\Product\Initialization\Helper::class => null,
        Magento\Catalog\Model\Product\Attribute\Repository::class => null,
        Magento\Catalog\Model\ProductRepository::class => null,
        Magento\Framework\DataObject\Copy::class => null,
        Magento\Quote\Model\Quote\Item\Processor::class => null,
        Magento\Sales\Model\Config::class => null,
        Magento\Customer\Model\Session\Validators\CutoffValidator::class => null,
        Magento\Customer\Model\Session\Storage::class => null,
        Magento\Tax\Model\Calculation::class => null,
        Magento\OfflineShipping\Model\SalesRule\Calculator::class => null,
        Magento\SalesRule\Model\Validator::class => null,
        Magento\Sales\Model\ResourceModel\Order\Payment::class => null,
        Magento\Sales\Model\ResourceModel\Order\Status\History::class => null,
        Magento\Sales\Model\ResourceModel\Order::class => null,
        Magento\Quote\Model\ResourceModel\Quote::class => null,
        Magento\Quote\Model\Quote::class => null,
        Magento\Backend\Model\Session::class => null,
        Magento\Checkout\Model\Session::class => null,
        Magento\Quote\Model\ResourceModel\Quote\Item::class => null,
        Magento\Backend\Model\Menu\Config::class => null,
        Magento\Backend\Model\Url::class => null,
        Magento\Customer\Model\Indexer\AttributeProvider::class => null,
        Magento\Framework\App\Cache\FlushCacheByTags::class => null,
        Magento\CustomerGraphQl\Model\Context\AddUserInfoToContext::class => null,
        Magento\Eav\Helper\Data::class => null,
    ],
    'updateCustomer' => [
        Magento\Framework\Url\QueryParamsResolver::class => null,
        Magento\Framework\Registry::class => null,
        Magento\Customer\Model\AddressRegistry::class => null,
        Magento\Customer\Model\CustomerRegistry::class => null,
        Magento\Eav\Model\ResourceModel\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\VersionControl\Metadata::class => null,
        'CustomerAddressSnapshot' => null,
        Magento\Customer\Model\ResourceModel\Address\Relation::class => null,
        Magento\Framework\Validator\Factory::class => null,
        Magento\Customer\Api\CustomerRepositoryInterface\Proxy::class => null,
        Magento\Customer\Model\ResourceModel\Address::class => null,
        Magento\Framework\Translate\Inline\ConfigInterface\Proxy::class => null,
        Magento\Framework\Translate\Inline::class => null,
        Magento\Framework\Json\Helper\Data::class => null,
        Magento\Directory\Helper\Data::class => null,
        Magento\TestFramework\Api\Config\Reader\FileResolver::class => null,
        Magento\Framework\Api\ExtensionAttribute\JoinProcessor::class => null,
        Magento\Customer\Model\ResourceModel\AddressRepository::class => null,
        Magento\Framework\Reflection\MethodsMap::class => null,
        Magento\Framework\Reflection\ExtensionAttributesProcessor\Proxy::class => null,
        Magento\Framework\Reflection\DataObjectProcessor::class => null,
        Magento\Framework\Api\DataObjectHelper::class => null,
        Magento\Customer\Model\AttributeMetadataConverter::class => null,
        Magento\Customer\Model\AttributeMetadataDataProvider::class => null,
        Magento\Customer\Model\Metadata\CustomerMetadata::class => null,
        Magento\Customer\Model\Metadata\AttributeMetadataCache::class => null,
        Magento\Customer\Model\Metadata\CustomerCachedMetadata::class => null,
        Magento\Customer\Model\Config\Share::class => null,
        'EavVersionControlSnapshot' => null,
        Magento\Customer\Model\AccountConfirmation::class => null,
        Magento\Customer\Model\ResourceModel\Customer::class => null,
        Magento\Framework\Api\ImageProcessor::class => null,
        Magento\Customer\Model\Session\Proxy::class => null,
        Magento\Customer\Model\Delegation\Storage::class => null,
        Magento\Customer\Model\GroupRegistry::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Metadata::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot::class => null,
        Magento\Tax\Model\TaxClass\Repository::class => null,
        Magento\Customer\Model\ResourceModel\GroupRepository::class => null,
        Magento\Customer\Model\ResourceModel\CustomerRepository::class => null,
        Magento\Customer\Helper\View::class => null,
        Magento\Framework\Indexer\IndexerRegistry::class => null,
        Magento\Customer\Model\Customer::class => null,
        Magento\Framework\Session\SessionMaxSizeConfig::class => null,
        Magento\Framework\Session\SaveHandler::class => null,
        Magento\Framework\Session\Storage::class => null,
        Magento\Paypal\Plugin\TransparentSessionChecker::class => null,
        Laminas\Uri\Uri::class => null,
        Magento\Backend\App\Area\FrontNameResolver::class => null,
        Magento\Backend\Helper\Data::class => null,
        Magento\GraphQl\Plugin\DisableSession::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Customer\Model\Session\SessionCleaner::class => null,
        Magento\Customer\Model\Authorization\CustomerSessionUserContext::class => null,
        Magento\JwtUserToken\Model\ConfigurableJwtSettingsProvider::class => null,
        Magento\JwtUserToken\Model\Reader::class => null,
        Magento\JwtUserToken\Model\ResourceModel\FastStorageRevokedWrapper::class => null,
        Magento\Webapi\Model\Authorization\TokenUserContext::class => null,
        Magento\Authorization\Model\CompositeUserContext::class => null,
        Magento\Webapi\Model\WebapiRoleLocator::class => null,
        Magento\Customer\Model\Authentication::class => null,
        Magento\Customer\Model\AccountManagement::class => null,
        Magento\Framework\MessageQueue\Code\Generator\Config\RemoteServiceReader\Communication::class => null,
        Magento\Framework\Webapi\ServiceInputProcessor::class => null,
        Magento\Framework\MessageQueue\Publisher\Config\RemoteService\Reader::class => null,
        Magento\Customer\Model\Session::class => null,
        Magento\Customer\Model\Plugin\CustomerFlushFormKey::class => null,
        Magento\CustomerGraphQl\Model\Context\AddUserInfoToContext::class => null,
        Magento\Tax\Model\Calculation::class => null,
        Magento\Catalog\Helper\Data::class => null,
        Magento\Checkout\Model\Session::class => null,
        Magento\Bundle\Pricing\Price\TaxPrice::class => null,
        Magento\Eav\Model\AttributeDataFactory::class => null,
        Magento\Customer\Observer\AfterAddressSaveObserver::class => null,
        Magento\LoginAsCustomer\Model\GetLoggedAsCustomerAdminId::class => null,
        Magento\LoginAsCustomerAssistance\Model\SetAssistance::class => null,
        Magento\LoginAsCustomerAssistance\Plugin\CustomerPlugin::class => null,
        Magento\CustomerGraphQl\Plugin\ClearCustomerSessionAfterRequest::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\Framework\Module\Manager::class => null,
        Magento\Framework\Translate\Inline\Proxy::class => null,
    ],
    'updateCustomerAddress' => [
        Magento\Framework\Url\QueryParamsResolver::class => null,
        Magento\Framework\Registry::class => null,
        Magento\Customer\Model\AddressRegistry::class => null,
        Magento\Customer\Model\CustomerRegistry::class => null,
        Magento\Eav\Model\ResourceModel\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\VersionControl\Metadata::class => null,
        'CustomerAddressSnapshot' => null,
        Magento\Customer\Model\ResourceModel\Address\Relation::class => null,
        Magento\Framework\Validator\Factory::class => null,
        Magento\Customer\Api\CustomerRepositoryInterface\Proxy::class => null,
        Magento\Customer\Model\ResourceModel\Address::class => null,
        Magento\Framework\Translate\Inline\ConfigInterface\Proxy::class => null,
        Magento\Framework\Translate\Inline::class => null,
        Magento\Framework\Json\Helper\Data::class => null,
        Magento\Directory\Helper\Data::class => null,
        Magento\TestFramework\Api\Config\Reader\FileResolver::class => null,
        Magento\Framework\Api\ExtensionAttribute\JoinProcessor::class => null,
        Magento\Customer\Model\ResourceModel\AddressRepository::class => null,
        Magento\Framework\Reflection\MethodsMap::class => null,
        Magento\Framework\Reflection\ExtensionAttributesProcessor\Proxy::class => null,
        Magento\Framework\Reflection\DataObjectProcessor::class => null,
        Magento\Framework\Api\DataObjectHelper::class => null,
        Magento\Customer\Model\AttributeMetadataConverter::class => null,
        Magento\Customer\Model\AttributeMetadataDataProvider::class => null,
        Magento\Customer\Model\Metadata\CustomerMetadata::class => null,
        Magento\Customer\Model\Metadata\AttributeMetadataCache::class => null,
        Magento\Customer\Model\Metadata\CustomerCachedMetadata::class => null,
        Magento\Customer\Model\Config\Share::class => null,
        'EavVersionControlSnapshot' => null,
        Magento\Customer\Model\AccountConfirmation::class => null,
        Magento\Customer\Model\ResourceModel\Customer::class => null,
        Magento\Framework\Api\ImageProcessor::class => null,
        Magento\Customer\Model\Session\Proxy::class => null,
        Magento\Customer\Model\Delegation\Storage::class => null,
        Magento\Tax\Model\TaxClass\Repository::class => null,
        Magento\Customer\Model\ResourceModel\CustomerRepository::class => null,
        Magento\Customer\Helper\View::class => null,
        Magento\Framework\Indexer\IndexerRegistry::class => null,
        Magento\Customer\Model\Customer::class => null,
        Magento\Framework\Session\SessionMaxSizeConfig::class => null,
        Magento\Framework\Session\SaveHandler::class => null,
        Magento\Framework\Session\Storage::class => null,
        Magento\Paypal\Plugin\TransparentSessionChecker::class => null,
        Laminas\Uri\Uri::class => null,
        Magento\Backend\App\Area\FrontNameResolver::class => null,
        Magento\Backend\Helper\Data::class => null,
        Magento\GraphQl\Plugin\DisableSession::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Customer\Model\Session\SessionCleaner::class => null,
        Magento\Customer\Model\Authorization\CustomerSessionUserContext::class => null,
        Magento\JwtUserToken\Model\ConfigurableJwtSettingsProvider::class => null,
        Magento\JwtUserToken\Model\Reader::class => null,
        Magento\JwtUserToken\Model\ResourceModel\FastStorageRevokedWrapper::class => null,
        Magento\Webapi\Model\Authorization\TokenUserContext::class => null,
        Magento\Authorization\Model\CompositeUserContext::class => null,
        Magento\Customer\Model\Authentication::class => null,
        Magento\Customer\Model\AccountManagement::class => null,
        Magento\Framework\MessageQueue\Code\Generator\Config\RemoteServiceReader\Communication::class => null,
        Magento\Framework\Webapi\ServiceInputProcessor::class => null,
        Magento\Framework\MessageQueue\Publisher\Config\RemoteService\Reader::class => null,
        Magento\Customer\Model\Session::class => null,
        Magento\Customer\Model\Plugin\CustomerFlushFormKey::class => null,
        Magento\CustomerGraphQl\Model\Context\AddUserInfoToContext::class => null,
        Magento\Tax\Model\Calculation::class => null,
        Magento\Eav\Model\AttributeDataFactory::class => null,
        Magento\Customer\Observer\AfterAddressSaveObserver::class => null,
        Magento\LoginAsCustomer\Model\GetLoggedAsCustomerAdminId::class => null,
        Magento\Framework\App\View::class => null,
        Magento\Framework\App\Action\Context::class => null,
        Magento\Catalog\Helper\Data::class => null,
        Magento\Checkout\Model\Session::class => null,
        Magento\Bundle\Pricing\Price\TaxPrice::class => null,
        Magento\CustomerGraphQl\Plugin\ClearCustomerSessionAfterRequest::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\Framework\Module\Manager::class => null,
        Magento\Framework\Translate\Inline\Proxy::class => null,
    ],
    'updateCustomerEmail' => [
        Magento\Framework\Url\QueryParamsResolver::class => null,
        Magento\Framework\Registry::class => null,
        Magento\Customer\Model\AddressRegistry::class => null,
        Magento\Customer\Model\CustomerRegistry::class => null,
        Magento\Eav\Model\ResourceModel\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\VersionControl\Metadata::class => null,
        'CustomerAddressSnapshot' => null,
        Magento\Customer\Model\ResourceModel\Address\Relation::class => null,
        Magento\Framework\Validator\Factory::class => null,
        Magento\Customer\Api\CustomerRepositoryInterface\Proxy::class => null,
        Magento\Customer\Model\ResourceModel\Address::class => null,
        Magento\Framework\Translate\Inline\ConfigInterface\Proxy::class => null,
        Magento\Framework\Translate\Inline::class => null,
        Magento\Framework\Json\Helper\Data::class => null,
        Magento\Directory\Helper\Data::class => null,
        Magento\TestFramework\Api\Config\Reader\FileResolver::class => null,
        Magento\Framework\Api\ExtensionAttribute\JoinProcessor::class => null,
        Magento\Customer\Model\ResourceModel\AddressRepository::class => null,
        Magento\Framework\Reflection\MethodsMap::class => null,
        Magento\Framework\Reflection\ExtensionAttributesProcessor\Proxy::class => null,
        Magento\Framework\Reflection\DataObjectProcessor::class => null,
        Magento\Framework\Api\DataObjectHelper::class => null,
        Magento\Customer\Model\AttributeMetadataConverter::class => null,
        Magento\Customer\Model\AttributeMetadataDataProvider::class => null,
        Magento\Customer\Model\Metadata\CustomerMetadata::class => null,
        Magento\Customer\Model\Metadata\AttributeMetadataCache::class => null,
        Magento\Customer\Model\Metadata\CustomerCachedMetadata::class => null,
        Magento\Customer\Model\Config\Share::class => null,
        'EavVersionControlSnapshot' => null,
        Magento\Customer\Model\AccountConfirmation::class => null,
        Magento\Customer\Model\ResourceModel\Customer::class => null,
        Magento\Framework\Api\ImageProcessor::class => null,
        Magento\Customer\Model\Session\Proxy::class => null,
        Magento\Customer\Model\Delegation\Storage::class => null,
        Magento\Customer\Model\GroupRegistry::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Metadata::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot::class => null,
        Magento\Tax\Model\TaxClass\Repository::class => null,
        Magento\Customer\Model\ResourceModel\GroupRepository::class => null,
        Magento\Customer\Model\ResourceModel\CustomerRepository::class => null,
        Magento\Customer\Helper\View::class => null,
        Magento\Framework\Indexer\IndexerRegistry::class => null,
        Magento\Customer\Model\Customer::class => null,
        Magento\Framework\Session\SessionMaxSizeConfig::class => null,
        Magento\Framework\Session\SaveHandler::class => null,
        Magento\Framework\Session\Storage::class => null,
        Magento\Paypal\Plugin\TransparentSessionChecker::class => null,
        Laminas\Uri\Uri::class => null,
        Magento\Backend\App\Area\FrontNameResolver::class => null,
        Magento\Backend\Helper\Data::class => null,
        Magento\GraphQl\Plugin\DisableSession::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Customer\Model\Session\SessionCleaner::class => null,
        Magento\Customer\Model\Authorization\CustomerSessionUserContext::class => null,
        Magento\JwtUserToken\Model\ConfigurableJwtSettingsProvider::class => null,
        Magento\JwtUserToken\Model\Reader::class => null,
        Magento\JwtUserToken\Model\ResourceModel\FastStorageRevokedWrapper::class => null,
        Magento\Webapi\Model\Authorization\TokenUserContext::class => null,
        Magento\Authorization\Model\CompositeUserContext::class => null,
        Magento\Webapi\Model\WebapiRoleLocator::class => null,
        Magento\Customer\Model\Authentication::class => null,
        Magento\Customer\Model\AccountManagement::class => null,
        Magento\Framework\MessageQueue\Code\Generator\Config\RemoteServiceReader\Communication::class => null,
        Magento\Framework\Webapi\ServiceInputProcessor::class => null,
        Magento\Framework\MessageQueue\Publisher\Config\RemoteService\Reader::class => null,
        Magento\Customer\Model\Session::class => null,
        Magento\Customer\Model\Plugin\CustomerFlushFormKey::class => null,
        Magento\CustomerGraphQl\Model\Context\AddUserInfoToContext::class => null,
        Magento\Tax\Model\Calculation::class => null,
        Magento\Catalog\Helper\Data::class => null,
        Magento\Checkout\Model\Session::class => null,
        Magento\Bundle\Pricing\Price\TaxPrice::class => null,
        Magento\Eav\Model\AttributeDataFactory::class => null,
        Magento\Customer\Observer\AfterAddressSaveObserver::class => null,
        Magento\LoginAsCustomer\Model\GetLoggedAsCustomerAdminId::class => null,
        Magento\CustomerGraphQl\Plugin\ClearCustomerSessionAfterRequest::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\Framework\Module\Manager::class => null,
        Magento\GraphQlCache\Model\Plugin\Auth\TokenIssuer::class => null,
        Magento\Framework\Validator\EmailAddress::class => null,
        Magento\CustomerGraphQl\Model\Customer\ValidateCustomerData\ValidateEmail::class => null,
        Magento\CustomerGraphQl\Model\Customer\ValidateCustomerData::class => null,
        Magento\Framework\App\View::class => null,
        Magento\Framework\App\Action\Context::class => null,
        Magento\Quote\Model\Quote\Address\Total\Collector::class => null,
    ],
    'generateCustomerToken' => [
        Magento\Customer\Model\CustomerRegistry::class => null,
        Magento\Eav\Model\ResourceModel\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\Attribute\Set::class => null,
        Magento\Eav\Model\Entity\VersionControl\Metadata::class => null,
        'CustomerAddressSnapshot' => null,
        Magento\Customer\Model\ResourceModel\Address\Relation::class => null,
        Magento\Customer\Api\CustomerRepositoryInterface\Proxy::class => null,
        Magento\Customer\Model\ResourceModel\Address::class => null,
        Magento\Framework\Translate\Inline\ConfigInterface\Proxy::class => null,
        Magento\Framework\Translate\Inline::class => null,
        Magento\Framework\Json\Helper\Data::class => null,
        Magento\Directory\Helper\Data::class => null,
        Magento\TestFramework\Api\Config\Reader\FileResolver::class => null,
        Magento\Framework\Api\ExtensionAttribute\JoinProcessor::class => null,
        Magento\Customer\Model\ResourceModel\AddressRepository::class => null,
        Magento\Framework\Reflection\MethodsMap::class => null,
        Magento\Framework\Reflection\ExtensionAttributesProcessor\Proxy::class => null,
        Magento\Framework\Reflection\DataObjectProcessor::class => null,
        Magento\Framework\Api\DataObjectHelper::class => null,
        Magento\Customer\Model\AttributeMetadataConverter::class => null,
        Magento\Customer\Model\AttributeMetadataDataProvider::class => null,
        Magento\Customer\Model\Metadata\CustomerMetadata::class => null,
        Magento\Customer\Model\Metadata\AttributeMetadataCache::class => null,
        Magento\Customer\Model\Metadata\CustomerCachedMetadata::class => null,
        Magento\Customer\Model\Config\Share::class => null,
        'EavVersionControlSnapshot' => null,
        Magento\Customer\Model\ResourceModel\Customer::class => null,
        Magento\Framework\Api\ImageProcessor::class => null,
        Magento\Customer\Model\Session\Proxy::class => null,
        Magento\Customer\Model\Delegation\Storage::class => null,
        Magento\Tax\Model\TaxClass\Repository::class => null,
        Magento\Customer\Model\ResourceModel\CustomerRepository::class => null,
        Magento\Customer\Helper\View::class => null,
        Magento\Customer\Model\Customer::class => null,
        Magento\Framework\Session\SessionMaxSizeConfig::class => null,
        Magento\Framework\Session\SaveHandler::class => null,
        Magento\Framework\Session\Storage::class => null,
        Magento\Paypal\Plugin\TransparentSessionChecker::class => null,
        Laminas\Uri\Uri::class => null,
        Magento\Backend\App\Area\FrontNameResolver::class => null,
        Magento\Backend\Helper\Data::class => null,
        Magento\GraphQl\Plugin\DisableSession::class => null,
        Magento\Framework\Session\Generic::class => null,
        Magento\Customer\Model\Session\SessionCleaner::class => null,
        Magento\Customer\Model\Authorization\CustomerSessionUserContext::class => null,
        Magento\JwtUserToken\Model\ConfigurableJwtSettingsProvider::class => null,
        Magento\JwtUserToken\Model\Reader::class => null,
        Magento\JwtUserToken\Model\ResourceModel\FastStorageRevokedWrapper::class => null,
        Magento\Webapi\Model\Authorization\TokenUserContext::class => null,
        Magento\Authorization\Model\CompositeUserContext::class => null,
        Magento\Customer\Model\Authentication::class => null,
        Magento\Customer\Model\Session::class => null,
        Magento\Framework\MessageQueue\Code\Generator\Config\RemoteServiceReader\Communication::class => null,
        Magento\Framework\Webapi\ServiceInputProcessor::class => null,
        Magento\Framework\MessageQueue\Publisher\Config\RemoteService\Reader::class => null,
    ],
    '*' => [
        Magento\TestFramework\Interception\PluginList::class => null,
        // memory leak, wrong sql, potential issues
        Magento\Framework\Event\Config\Data::class => null,
        Magento\Framework\App\AreaList::class => null,
        Magento\Framework\App\DeploymentConfig::class => null,
        Magento\Theme\Model\View\Design::class => null,
        Magento\Framework\App\Cache\Frontend\Pool::class => null,
        Magento\Framework\App\Cache\Type\FrontendPool::class => null,
        Magento\Framework\App\DeploymentConfig\Writer::class => null,
        Magento\Framework\App\Cache\State::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\RemoteStorage\Model\Config::class => null,
        Magento\Store\Model\Config\Processor\Fallback::class => null,
        Magento\Framework\Lock\LockBackendFactory::class => null,
        'customRemoteFilesystem' => null,
        'systemConfigQueryLocker' => null,
        Magento\Framework\View\Design\FileResolution\Fallback\TemplateFile::class => null,
        Magento\Config\App\Config\Source\RuntimeConfigSource::class => null,
        'scopesConfigInitialDataProvider' => null,
        Magento\Developer\Model\Logger\Handler\Debug::class => null,
        Magento\Developer\Model\Logger\Handler\Syslog::class => null,
        Magento\Store\App\Config\Source\RuntimeConfigSource::class => null,
        Magento\Store\App\Config\Type\Scopes::class => null,
        Magento\Framework\Module\Dir\Reader::class => null,
        Magento\Framework\Module\PackageInfo::class => null,
        Magento\Framework\App\Language\Dictionary::class => null,
        Magento\Framework\ObjectManager\ConfigInterface::class => null,
        Magento\Framework\App\Cache\Type\Config::class => null,
        Magento\Framework\Interception\PluginListGenerator::class => null,
        Magento\TestFramework\App\Config::class => null,
        Magento\TestFramework\Request::class => null,
        Magento\Framework\View\FileSystem::class => null,
        Magento\Framework\App\Config\FileResolver::class => null,
        Magento\TestFramework\ErrorLog\Logger::class => null,
        'translationConfigSourceAggregated' => null,
        Magento\Framework\App\Request\Http\Proxy::class => null,
        Magento\Framework\Event\Config\Reader\Proxy::class => null,
        Magento\Theme\Model\View\Design\Proxy::class => null,
        Magento\Translation\Model\Source\InitialTranslationSource\Proxy::class => null,
        Magento\Translation\App\Config\Type\Translation::class => null,
        Magento\Backend\App\Request\PathInfoProcessor\Proxy::class => null,
        Magento\Framework\View\Asset\Source::class => null,
        Magento\Framework\Translate\ResourceInterface\Proxy::class => null,
        Magento\Framework\Locale\Resolver\Proxy::class => null,
        Magento\MediaStorage\Helper\File\Storage\Database::class => null,
        Magento\Framework\App\Cache\Proxy::class => null,
        Magento\Framework\Translate::class => null,
        Magento\Store\Model\StoreManager::class => null,
        Magento\Framework\App\Http\Context::class => null,
        Magento\TestFramework\Response::class => null,
        Magento\Store\Model\WebsiteRepository::class => null,
        Magento\Framework\Locale\Resolver::class => null,
        Magento\Store\Model\GroupRepository::class => null,
        Magento\Store\Model\StoreRepository::class => null,
        Magento\Framework\View\Design\Fallback\RulePool::class => null,
        Magento\Framework\View\Asset\Repository::class => null,
        Magento\Framework\HTTP\Header::class => null,
        Magento\Framework\App\Route\Config::class => null,
        Magento\Store\Model\System\Store::class => null,
        Magento\AwsS3\Driver\CredentialsCache::class => null,
        Magento\Eav\Model\Config::class => null,
        'AssetPreProcessorPool' => null,
        Magento\GraphQl\Model\Query\ContextFactory::class => null,
        'viewFileMinifiedFallbackResolver' => null,
        Magento\Framework\View\Asset\Minification::class => null,
        Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection::class => null,
        Magento\Framework\Url::class => null,
        Magento\Framework\HTTP\PhpEnvironment\RemoteAddress::class => null,
        Magento\Framework\Module\ModuleList::class => null,
        Magento\Framework\Module\Manager::class => null,
        /* AddUserInfoToContext has userContext changed by Magento\GraphQl\Model\Query\ContextFactory,
         * but we need to make this more robust in secure in case of unforeseen bugs.
         * resetState for userContext makes sense, but we need to make sure that it cannot copy current userContext. */
        Magento\CustomerGraphQl\Model\Context\AddUserInfoToContext::class => null, // FIXME: see above comment
        Magento\Framework\ObjectManager\DefinitionInterface::class => null,
        Magento\TestFramework\App\State::class => null,
        Magento\GraphQl\App\State\SkipListAndFilterList::class => null, // Yes, our test uses mutable state itself :-)
        Magento\Framework\App\ResourceConnection::class => null,
        Magento\Framework\App\ResourceConnection\Interceptor::class => null,
        Magento\Framework\Session\SaveHandler::class => null, // TODO: check this
        Magento\TestFramework\Db\Adapter\Mysql\Interceptor::class => null,
    ],
    '*-fromConstructed' => [
        Magento\GraphQl\App\State\ObjectManager::class => null,
        Magento\RemoteStorage\Filesystem::class => null,
        Magento\Framework\App\Cache\Frontend\Factory::class => null,
        Magento\Framework\Config\Scope::class => null,
        Magento\TestFramework\ObjectManager\Config::class => null,
        Magento\Framework\ObjectManager\Definition\Runtime::class => null,
        Magento\Framework\Cache\LockGuardedCacheLoader::class => null,
        Magento\Config\App\Config\Type\System::class => null,
        Magento\Framework\View\Asset\PreProcessor\Pool::class => null,
        Magento\Framework\Xml\Parser::class => null, # TODO: why?!?! errorHandlerIsActive
        Magento\Framework\App\Area::class => null,
        Magento\Store\Model\Store\Interceptor::class => null,
        Magento\GraphQl\App\State\Comparator::class => null, // Yes, our test uses mutable state itself :-)
        Magento\Framework\GraphQl\Query\QueryParser::class =>
            null, // TODO: Do we need to add a reset for when config changes?
        Magento\Framework\App\Http\Context\Interceptor::class => null,
        Magento\Framework\HTTP\LaminasClient::class => null,
        Magento\Customer\Model\GroupRegistry::class =>
            null, // FIXME: This looks like it needs _resetState or else it would be bug
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Metadata::class => null,
        Magento\Framework\App\DeploymentConfig::class => null,
        Laminas\Uri\Uri::class => null,
        Magento\Framework\App\Cache\Frontend\Pool::class => null,
        Magento\Framework\App\Cache\State::class =>
            null, // TODO: Need to confirm that this gets reset when poison pill triggers
        Magento\TestFramework\App\State\Interceptor::class => null,
        Magento\TestFramework\App\MutableScopeConfig::class => null,
        Magento\TestFramework\Store\StoreManager::class => null,
        Magento\TestFramework\Workaround\Override\Config\RelationsCollector::class => null,
        Magento\Framework\Translate\Inline::class =>
            null, // TODO: Need to confirm that this gets reset when poison pill triggers
        Magento\Framework\Reflection\MethodsMap::class => null,
        Magento\Framework\Session\SaveHandler::class => null,
        Magento\Customer\Model\GroupRegistry::class => null, // FIXME: Needs _resetState for $registry
        Magento\Customer\Model\Group\Interceptor::class => null,
        Magento\Store\Model\Group\Interceptor::class => null,
        Magento\Directory\Model\Currency\Interceptor::class => null,
        Magento\Theme\Model\Theme\ThemeProvider::class => null, // Needs _resetState for themes
        Magento\Theme\Model\View\Design::class => null,
        Magento\Catalog\Model\Category\AttributeRepository::class =>
            null, // FIXME: Needs resetState OR reset when poison pill triggered.
        Magento\Framework\Search\Request\Cleaner::class => null,  // FIXME: Needs resetState
        Magento\Catalog\Model\ResourceModel\Category\Interceptor::class => null,
        Magento\Catalog\Model\Attribute\Backend\DefaultBackend\Interceptor::class => null,
        Magento\GraphQlCache\Model\Resolver\IdentityPool::class => null,
        Magento\Inventory\Model\Stock::class => null,
        Magento\InventorySales\Model\SalesChannel::class => null,
        Magento\InventoryApi\Api\Data\StockExtension::class => null,
        Magento\Elasticsearch\Model\Adapter\FieldMapper\FieldMapperResolver::class => null,
        Magento\Catalog\Model\ResourceModel\Eav\Attribute\Interceptor::class => null,
        Magento\Catalog\Model\Category\Attribute\Backend\Image\Interceptor::class => null,
        Magento\Catalog\Model\Attribute\Backend\Startdate\Interceptor::class => null,
        Magento\Eav\Model\Entity\Attribute\Backend\Datetime\Interceptor::class => null,
        Magento\Catalog\Model\Category\Attribute\Backend\Sortby\Interceptor::class => null,
        Magento\Catalog\Model\Category\Attribute\Backend\LayoutUpdate\Interceptor::class => null,
        Magento\Catalog\Model\Attribute\Backend\Customlayoutupdate\Interceptor::class => null,
        Magento\Eav\Model\Entity\Attribute\Backend\Time\Created\Interceptor::class => null,
        Magento\Eav\Model\Entity\AttributeBackendTime\Updated\Interceptor::class => null,
        Magento\Eav\Model\Entity\Attribute\Backend\Increment\Interceptor::class => null,
        Magento\Eav\Model\Entity\Interceptor::class => null,
        Magento\Framework\View\Asset\RepositoryMap::class =>
            null, // TODO: does this need to reset on poison pill trigger?
        Magento\Framework\Url\RouteParamsResolver\Interceptor::class => null,
        Magento\Theme\Model\Theme::class => null,
        Magento\Catalog\Model\ResourceModel\Category\Collection\Interceptor::class => null,
        Magento\Catalog\Model\Category\Interceptor::class => null,
        Magento\CatalogGraphQl\Model\Resolver\Products\DataProvider\CategoryTree\Wrapper\NodeWrapper::class => null,
        Magento\Framework\Api\AttributeValue::class => null,
        Magento\Catalog\Model\ResourceModel\Product\Collection\ProductLimitation::class => null,
        Magento\Catalog\Model\ResourceModel\Product\Interceptor::class => null,
        Magento\Catalog\Model\ResourceModel\Product\Collection\Interceptor::class => null,
        Magento\Framework\Api\Search\SearchCriteria::class => null,
        Magento\Framework\Api\SortOrder::class => null,
        Magento\Framework\Api\Search\SearchResult::class => null,
        Magento\Eav\Model\Entity\Attribute\Backend\Time\Updated\Interceptor::class => null,
        Magento\CatalogInventory\Model\Stock\Item\Interceptor::class => null,
        Magento\Framework\View\Asset\File::class => null,
        Magento\Customer\Model\Attribute\Interceptor::class => null,
        Magento\Framework\GraphQl\Schema\SchemaGenerator::class => null,
        Magento\Customer\Model\ResourceModel\Customer::class => null,
        Magento\Framework\Model\ResourceModel\Db\VersionControl\Snapshot::class => null,
        Magento\Framework\App\PageCache\Version::class => null,
        Magento\Framework\App\PageCache\Identifier::class => null,
        Magento\Framework\App\PageCache\Kernel::class => null,
        Magento\Translation\Model\Source\InitialTranslationSource::class => null,
        Magento\Framework\GraphQl\Schema\Type\Output\OutputMapper::class => null,
        Magento\Framework\GraphQl\Schema\Type\Input\InputMapper::class => null,
        Magento\Framework\Filesystem\DriverPool::class => null,
        Magento\Framework\Filesystem\Directory\WriteFactory::class => null,
        Magento\Catalog\Model\Product\Media\Config::class => null,
        Magento\Catalog\Model\Product\Type\Interceptor::class =>
            null, // Note: We may need to check to see if this needs to be reset when config changes
        Magento\ConfigurableProduct\Model\Product\Type\Configurable\Interceptor::class => null,
        Magento\Catalog\Model\Product\Type\Simple\Interceptor::class => null,
        Magento\Customer\Model\Session\Storage::class =>
            null,  // FIXME: race condition with Magento\Customer\Model\Session::_resetState()
        Magento\Framework\Module\Manager::class => null,
        Magento\Eav\Api\Data\AttributeExtension::class
        => null, // FIXME: This needs to be fixed.   is_pagebuilder_enabled 0 => null
        Magento\TestFramework\Event\Magento::class => null,
        Magento\Staging\Model\VersionManager\Interceptor::class => null, // Has good _resetState
        Magento\Webapi\Model\Authorization\TokenUserContext::class => null, // Has good _resetState
        Magento\Store\Model\Website\Interceptor::class => null, // reset by poison pill
        Magento\Eav\Model\Entity\Type::class => null, // attribute types should be destroyed by poison pill
        Magento\Eav\Model\Entity\Attribute\Backend\DefaultBackend\Interceptor::class =>
            null, // attribute types should be destroyed by poison pill
        Magento\TestFramework\Mail\Template\TransportBuilderMock\Interceptor::class => null, // only for testing
        Magento\Customer\Model\Data\Customer::class =>
            null, // FIXME: looks like a bug.  Why is this not destroyed?
        Magento\Customer\Model\Customer\Interceptor::class =>
            null, // FIXME: looks like a bug.  Why is this not destroyed?
        Magento\Framework\ForeignKey\ObjectRelationProcessor\EnvironmentConfig::class =>
            null, // OK; shouldn't change outside of deployment
        Magento\Indexer\Model\Indexer\Interceptor::class =>
            null, // FIXME: looks like this needs to be reset ?
        Magento\Indexer\Model\Indexer\State::class =>
            null, // FIXME: looks like this needs to be reset ?
        Magento\Customer\Model\ResourceModel\Attribute\Collection\Interceptor::class =>
            null, // TODO: does this need to be fixed?
        Magento\Customer\Model\ResourceModel\Address\Attribute\Collection\Interceptor::class =>
            null, // TODO: why is this not getting destroyed?
        Magento\Customer\Model\Indexer\Address\AttributeProvider::class =>
            null, // TODO: I don't think this gets reset after poison pill, so it may need _resetState
        Magento\Customer\Model\Indexer\AttributeProvider::class =>
            null, // TODO: I don't think this gets reset after poison pill, so it may need _resetState
        Magento\Config\Model\Config\Structure\Data::class => null, // should be cleaned after poison pill
        Magento\Framework\Filter\Template\SignatureProvider::class =>
            null, // TODO: does this need _resetState?
        Magento\Customer\Model\ResourceModel\Address\Interceptor::class =>
            null, // customer_address_entity table info
        Magento\LoginAsCustomerAssistance\Model\IsAssistanceEnabled::class =>
            null, // FIXME: needs resetSate
        Magento\Quote\Model\Quote\Address\Total\Subtotal::class => null, // FIXME: these should not be reused.
        Magento\Quote\Model\Quote\Address\Total\Grand::class =>
            null, // FIXME: these should not be reused.
        Magento\SalesRule\Model\Quote\Address\Total\ShippingDiscount::class =>
            null, // FIXME: these should not be reused.
        Magento\Weee\Model\Total\Quote\WeeeTax::class => null, // FIXME: these should not be reused.
        Magento\Tax\Model\Sales\Total\Quote\Shipping\Interceptor::class => null, // FIXME: these should not be reused.
        Magento\Tax\Model\Sales\Total\Quote\Subtotal\Interceptor::class => null, // FIXME: these should not be reused.
        Magento\Ui\Config\Reader\FileResolver::class =>
            null, // TODO: confirm this gets reset from poison pill or is otherwise okay.
        Magento\Ui\Config\Converter::class =>
            null, // TODO: confirm this is cleaned when poison pill triggered
    ],
    '' => [
    ],
];
