<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

use Magento\TestFramework\Helper\Bootstrap;
use Magento\UrlRewrite\Model\UrlRewrite;

$objectManager = Bootstrap::getObjectManager();

/** @var int Product Id */
$productId = 708579;

/** @var UrlRewrite $urlRewrite */
$urlRewrite = $objectManager->create(UrlRewrite::class);
$urlRewrite->setEntityType('custom')
    ->setRequestPath('non-exist-entity.html')
    ->setTargetPath('catalog/product/view/id/' . $productId)
    ->setRedirectType(0)
    ->setStoreId(1)
    ->setDescription(null)
    ->setIsAutogenerated(0);

$urlRewrite->save();
