# Magento Functional Testing Framework

----

## System Requirements
[Magento Functional Testing Framework system requirements](http://devdocs.magento.com/guides/v2.2/magento-functional-testing-framework/getting-started.html#prepare-environment)

## Installation
To install the Magento Functional Testing Framework, see [Getting Started](http://devdocs.magento.com/guides/v2.2/magento-functional-testing-framework/getting-started.html)

## Contributing
Contributions can take the form of new components or features, changes to existing features, tests, documentation (such as developer guides, user guides, examples, or specifications), bug fixes, optimizations, or just good suggestions.

To learn about how to make a contribution, click [here][1].

To open an issue, click [here][2].

To suggest documentation improvements, click [here][3].

[1]: <http://devdocs.magento.com/guides/v2.2/magento-functional-testing-framework/contribution-guidelines.html>
[2]: <https://github.com/magento/magento2-functional-testing-framework/issues>
[3]: <http://devdocs.magento.com>

### Labels applied by the MFTF team

Refer to the tables with descriptions of each label below. These labels are applied by the MFTF development team to community contributed issues and pull requests, to communicate status, impact, or which team is working on it.

### Pull Request Status

Label| Description
---|---
**accept**| The pull request has been accepted and will be merged into mainline code. 
**reject**| The pull request has been rejected and will not be merged into mainline code. Possible reasons can include but are not limited to: issue has already been fixed in another code contribution, or there is an issue with the code contribution.
**needsUpdate**| The Magento Team needs additional information from the reporter to properly prioritize and process the pull request.

### Issue Resolution Status

Label| Description
---|---
**acknowledged**| The Magento Team has validated the issue and an internal ticket has been created.
**needsUpdate**| The Magento Team needs additional information from the reporter to properly prioritize and process the issue or pull request.
**cannot reproduce**| The Magento Team has not confirmed that this issue contains the minimum required information to reproduce. 
**non-issue**| The Magento Team has not recognised any issue according to provided information.

### Domains Impacted

Label| Description
---|---
**PROD**| Affects the Product team (mostly feature requests or business logic change).
**DOC**| Affects Documentation domain.
**TECH**| Affects Architect Group (mostly to make decisions around technology changes).

### Type

Label| Description
---|---
**bugfix**| The issue or pull request relates to bug fixing.
**enhancement**| The issue or pull request that raises the MFTF to a higher degree (for example new features, optimization, refactoring, etc).

## License

Each Magento source file included in this distribution is licensed under APL 3.0

Please see LICENSE_APL3.txt for the full text of the APL 3.0 license or contact license@magentocommerce.com for a copy.
