<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
$mapping = [
    [
        'label' => 'Open Home Page',
        'uri' => '^\/$',
        'title' => 'Home Page',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Home Page',
        'uri' => '^\/$',
        'title' => 'Home Page\(Catalog Browsing',
        'scenario' => 'Catalog Browsing',
    ],
    [
        'label' => 'Open Home Page',
        'uri' => '^\/$',
        'title' => 'Home Page\(Search',
        'scenario' => 'Search',
    ],
    [
        'label' => 'Open Home Page',
        'uri' => '^\/$',
        'title' => 'Home Page\(Add To Cart',
        'scenario' => 'Add to Cart',
    ],
    [
        'label' => 'Open Home Page',
        'uri' => '^\/$',
        'title' => 'Home Page\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Open Home Page',
        'uri' => '^\/$',
        'title' => 'Home Page\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Open Category Page',
        'uri' => '\/category-\d+\.html',
        'title' => 'Open Category',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Category Page',
        'uri' => '\/category-\d+\.html',
        'title' => 'Open Category\(Catalog Browsing',
        'scenario' => 'Catalog Browsing',
    ],
    [
        'label' => 'Open Category Page',
        'uri' => '\/category-\d+\.html',
        'title' => 'Open Category\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Open Category Page',
        'uri' => '\/category-\d+\.html',
        'title' => 'Open Category\(Product Compare',
        'scenario' => 'Compare Products',
    ],
    [
        'label' => 'Open Category Page',
        'uri' => '\/category-\d+\.html',
        'title' => 'Open Category\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Open Category Page',
        'uri' => '\/category-\d+\.html',
        'title' => 'Open Category\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Open Simple Product Page (Guest)',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^(?:Simple )?Product \d+ View',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Simple Product Page (Customer)',
        'uri' => '\/simple-product-\d+\.html',
        'title' => 'Simple Product View',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product \d+ View\(Catalog Browsing',
        'scenario' => 'Catalog Browsing',
    ],
    [
        'label' => 'Open Product Page',
        'uri' => '\/(?:simple|configurable)-product-\d+\.html',
        'title' => '^Product \d+ View(\s\d)?\(Search',
        'scenario' => 'Search',
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product \d+ View\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product \d+ View\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product View\(WishList',
        'scenario' => 'WishList',
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product \d+ View\(Product Compare',
        'scenario' => 'Compare Products',
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product \d+ View\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Open Simple Product Page',
        'uri' => '\/simple-product-\d+\.html',
        'title' => '^Simple Product \d+ View\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Open Configurable Product Page',
        'uri' => '\/configurable-product-\d+\.html',
        'title' => 'Configurable Product \d+ View',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Configurable Product Page',
        'uri' => '\/configurable-product-\d+\.html',
        'title' => 'Configurable Product \d+ View\(Catalog Browsing',
        'scenario' => 'Catalog Browsing',
    ],
    [
        'label' => 'Open Configurable Product Page',
        'uri' => '\/configurable-product-\d+\.html',
        'title' => 'Configurable Product \d+ View\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Open Configurable Product Page',
        'uri' => '\/configurable-product-\d+\.html',
        'title' => 'Configurable Product \d+ View\(Product Compare',
        'scenario' => 'Compare Products',
    ],
    [
        'label' => 'Open Configurable Product Page',
        'uri' => '\/configurable-product-\d+\.html',
        'title' => 'Configurable Product \d+ View\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Open Configurable Product Page',
        'uri' => '\/configurable-product-\d+\.html',
        'title' => 'Configurable Product \d+ View\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Quick Search',
        'uri' => '\/catalogsearch\/result',
        'title' => 'Search\(SearchQuick\)',
        'scenario' => 'Search',
        'is_storefront' => true,
    ],
    [
        'label' => 'Ajax Product Review',
        'uri' => '\/review\/product\/listAjax\/id\/\d+',
        'title' => 'Ajax Review.*\(Search',
        'scenario' => 'Search',
        'is_storefront' => true,
    ],
    [
        'label' => 'Quick Search With Filter',
        'uri' => '\/catalogsearch\/result',
        'title' => 'Search(?:\s\d)?\(SearchQuickWithFilter\)',
        'scenario' => 'Search',
        'is_storefront' => true,
    ],
    [
        'label' => 'Filter By Attribute',
        'uri' => '\/catalogsearch\/result',
        'title' => 'Filter by Attribute',
        'scenario' => 'Search',
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Advanced Search Page',
        'uri' => '\/catalogsearch\/advanced',
        'title' => 'Open Advanced Search',
        'scenario' => 'Search',
        'is_storefront' => true,
    ],
    [
        'label' => 'Perform Advanced Search',
        'uri' => '\/catalogsearch\/advanced\/result',
        'title' => '^Search\(SearchAdvanced\)',
        'scenario' => 'Search',
        'is_storefront' => true,
    ],
    [
        'label' => 'Add Simple Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Simple.*Add To Cart',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Add Simple Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Simple.*Add To Cart\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Add Simple Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Simple.*Add To Cart\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Add Simple Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Simple.*Add To Cart\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Add Configurable Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Configurable.*Add To Cart',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Add Configurable Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Configurable.*Add To Cart\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Add Configurable Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Configurable.*Add To Cart\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Add Configurable Product To Cart',
        'uri' => '\/checkout\/cart\/add\/uenc',
        'title' => 'Configurable.*Add To Cart\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Load Customer Cart Section',
        'uri' => '\/customer\/section\/load.*sections=cart',
        'title' => '(Customer Section )?Load\s*(?:Guest|Customer)+',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Load Customer Cart Section',
        'uri' => '\/customer\/section\/load.*sections=cart',
        'title' => 'Load Guest\d?\(Add To Cart',
        'scenario' => 'Add To Cart',
    ],
    [
        'label' => 'Load Customer Cart Section',
        'uri' => '\/customer\/section\/load.*sections=cart',
        'title' => 'Load Guest\d?\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
    ],
    [
        'label' => 'Load Customer Cart Section',
        'uri' => '\/customer\/section\/load.*sections=cart',
        'title' => 'Load Customer\d?\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Delete Item From Shopping Cart',
        'uri' => '\/checkout\/cart\/delete',
        'title' => 'Delete From Cart',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Login Page',
        'uri' => '\/customer\/account\/login',
        'title' => 'Open Login Page',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Open Login Page',
        'uri' => '\/customer\/account\/login',
        'title' => 'Open Login Page\(WishList',
        'scenario' => 'WishList',
    ],
    [
        'label' => 'Open Login Page',
        'uri' => '\/customer\/account\/login',
        'title' => 'Open Login Page\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Ajax Load Login Form',
        'uri' => '\/page_cache\/block\/render',
        'title' => 'Ajax Load Login Form',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Ajax Load Login Form',
        'uri' => '\/page_cache\/block\/render',
        'title' => 'Ajax Load Login Form\(WishList',
        'scenario' => 'WishList',
    ],
    [
        'label' => 'Ajax Load Login Form',
        'uri' => '\/page_cache\/block\/render',
        'title' => 'Ajax Load Login Form\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Login Action',
        'uri' => '\/customer\/account\/loginPost',
        'title' => '^Login\s*\(',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Login Action',
        'uri' => '\/customer\/account\/loginPost',
        'title' => 'Login\s*\(WishList',
        'scenario' => 'WishList',
    ],
    [
        'label' => 'Login Action',
        'uri' => '\/customer\/account\/loginPost',
        'title' => 'Login\s*\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
    ],
    [
        'label' => 'Add Product To Wishlist',
        'uri' => '\/wishlist\/index\/add',
        'title' => 'Add To Wishlist',
        'scenario' => 'Wishlist',
        'is_storefront' => true,
    ],
    [
        'label' => 'Load Wishlist Section',
        'uri' => '\/customer\/section\/load.*sections=wishlist',
        'title' => 'Load Wishlist',
        'scenario' => 'Wishlist',
        'is_storefront' => true,
    ],
    [
        'label' => 'Delete Item From Wishlist',
        'uri' => 'wishlist\/index\/remove',
        'title' => 'Clear Wishlist',
        'scenario' => 'Wishlist',
        'is_storefront' => true,
    ],
    [
        'label' => 'Logout Action',
        'uri' => '\/customer\/account\/logout',
        'title' => 'Logout',
        'is_service_url' => true,
        'is_storefront' => true,
    ],
    [
        'label' => 'Add Simple Product To Compare List',
        'uri' => '\/catalog\/product_compare\/add',
        'title' => '^(Simple )?Product .* Comparison Add',
        'scenario' => 'Compare Products',
        'is_storefront' => true,
    ],
    [
        'label' => 'Add Configurable Product To Compare List',
        'uri' => '\/catalog\/product_compare\/add',
        'title' => 'Configurable Product .* Comparison Add',
        'scenario' => 'Compare Products',
        'is_storefront' => true,
    ],
    [
        'label' => 'Compare Products',
        'uri' => '\/catalog\/product_compare\/index\/items\/',
        'title' => 'Compare Products\(.*',
        'scenario' => 'Compare Products',
        'is_storefront' => true,
    ],
    [
        'label' => 'Remove Products From Comparison',
        'uri' => '\/catalog\/product_compare\/clear',
        'title' => 'Compare Products Clear',
        'scenario' => 'Compare Products',
        'is_storefront' => true,
    ],
    [
        'label' => 'Start Checkout (Guest)',
        'uri' => '\/checkout\/$',
        'title' => 'Checkout Start\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
        'is_storefront' => true,
    ],
    [
        'label' => 'Check If Email Is Available',
        'uri' => '\/rest\/default\/V1\/customers\/isEmailAvailable',
        'title' => 'Checkout Email Available',
        'scenario' => 'Checkout By Guest',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Estimate Shipping Methods (Guest)',
        'uri' => '\/rest\/default\/V1\/guest-carts\/[a-f0-9]+\/estimate-shipping-methods',
        'title' => 'Checkout Estimate Shipping Methods\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Billing/Shipping Information (Guest)',
        'uri' => '\/rest\/default\/V1\/guest-carts\/[a-f0-9]+\/shipping-information',
        'title' => 'Checkout Billing\/Shipping Information\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Payment/Info Place Order (Guest)',
        'uri' => '\/rest\/default\/V1\/guest-carts\/[a-f0-9]+\/payment-information',
        'title' => 'Checkout Payment Info\/Place Order\(Checkout By Guest',
        'scenario' => 'Checkout By Guest',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Success Page By Guest',
        'uri' => '\/checkout\/onepage\/success',
        'title' => 'Checkout success\(Checkout By Guest\)',
        'scenario' => 'Checkout By Guest',
        'is_storefront' => true,
    ],
    [
        'label' => 'Start Checkout (Customer)',
        'uri' => '\/checkout\/$',
        'title' => 'Checkout Start\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Estimate Shipping Methods (Customer)',
        'uri' => '\/rest\/default\/V1\/carts\/mine\/estimate-shipping-methods-by-address-id',
        'title' => 'Checkout Estimate Shipping Methods\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Billing/Shipping Information (Customer)',
        'uri' => '\/rest\/default\/V1\/carts\/mine\/shipping-information',
        'title' => 'Checkout Billing\/Shipping Information\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Payment/Info Place Order (Customer)',
        'uri' => '\/rest\/default\/V1\/carts\/mine\/payment-information',
        'title' => 'Checkout Payment Info\/Place Order\(Checkout By Customer',
        'scenario' => 'Checkout By Customer',
        'is_storefront' => true,
    ],
    [
        'label' => 'Checkout Success Page By Customer',
        'uri' => '\/checkout\/onepage\/success',
        'title' => 'Checkout success\(Checkout By Customer\)',
        'scenario' => 'Checkout By Customer',
        'is_storefront' => true,
    ],
    [
        'label' => 'Login To Admin Panel',
        'uri' => '\/admin',
        'title' => '- Login$',
        'is_service_url' => true
    ],
    [
        'label' => 'Login To Admin Panel - Submit Form',
        'uri' => '\/admin\/admin\/dashboard',
        'title' => '- Login Submit Form',
        'is_service_url' => true,
    ],
    [
        'label' => 'Admin - Edit Simple Product',
        'uri' => '\/admin\/catalog\/product\/edit\/id',
        'title' => 'Admin Edit Product - Edit Simple Product$',
        'scenario' => 'Admin - Edit Product',
    ],
    [
        'label' => 'Admin - Validate Simple Product',
        'uri' => '\/admin\/catalog\/product\/validate\/id',
        'title' => 'Admin Edit Product - Edit Simple Product Validate',
        'scenario' => 'Admin - Edit Product',
    ],
    [
        'label' => 'Admin - Save Simple Product',
        'uri' => '\/admin\/catalog\/product\/save\/id',
        'title' => 'Admin Edit Product - Edit Simple Product Save',
        'scenario' => 'Admin - Edit Product',
    ],
    [
        'label' => 'Admin - Edit Configurable Product',
        'uri' => '\/admin\/catalog\/product\/edit\/id',
        'title' => 'Admin Edit Product - Edit Configurable Product$',
        'scenario' => 'Admin - Edit Product',
    ],
    [
        'label' => 'Admin - Validate Configurable Product',
        'uri' => '\/admin\/catalog\/product\/validate\/id',
        'title' => 'Admin Edit Product - Edit Configurable Product Validate',
        'scenario' => 'Admin - Edit Product',
    ],
    [
        'label' => 'Admin - Save Configurable Product',
        'uri' => '\/admin\/catalog\/product\/save\/id',
        'title' => 'Admin Edit Product - Edit Configurable Product Save',
        'scenario' => 'Admin - Edit Product',
    ],
    [
        'label' => 'Admin - Open Product Page',
        'uri' => '\/admin\/catalog\/product\/',
        'title' => 'Admin Create Product - Catalog Product',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Create New Bundle Product',
        'uri' => '\/admin\/catalog\/product\/new\/set\/4\/type\/bundle\/',
        'title' => 'Admin Create Product - New Bundle Product$',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Validate New Bundle Product',
        'uri' => '\/admin\/catalog\/product\/validate\/set\/4\/',
        'title' => 'Admin Create Product - New Bundle Product Validate',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Save New Bundle Product',
        'uri' => '\/admin\/catalog\/product\/save\/set\/4\/type\/bundle\/back\/edit\/active_tab\/product-details\/',
        'title' => 'Admin Create Product - New Bundle Product Save',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Create New Configurable Product',
        'uri' => '\/admin\/catalog\/product\/new\/set\/4\/type\/configurable\/',
        'title' => 'Admin Create Product - New Configurable Product$',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Create Product Options',
        'uri' => '\/admin\/catalog\/product_attribute\/createOptions\/\?isAjax=true',
        'title' => 'Admin Create Product - Create Options',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Validate New Configurable Product',
        'uri' => '\/admin\/catalog\/product\/validate\/set\/4\/',
        'title' => 'Admin Create Product - New Configurable Product Validate',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Save New Configurable Product',
        'uri' => '\/admin\/catalog\/product\/save\/set\/4\/type\/configurable'
                . '\/back\/edit\/active_tab\/product-details\/',
        'title' => 'Admin Create Product - New Configurable Product Save',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Create New Downloadable Product',
        'uri' => '\/admin\/catalog\/product\/new\/set\/4\/type\/downloadable\/',
        'title' => 'Admin Create Product - New Downloadable Product$',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Add Original File To Downloadable Product',
        'uri' => '\/admin\/downloadable_file\/upload\/type\/links\/\?isAjax=true',
        'title' => 'Admin Create Product - New Downloadable Upload Original File',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Add Sample File To Downloadable Product',
        'uri' => '\/admin\/downloadable_file\/upload\/type\/samples\/\?isAjax=true',
        'title' => 'Admin Create Product - New Downloadable Upload Sample File',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Validate New Downloadable Product',
        'uri' => '\/admin\/catalog\/product\/validate\/set\/4\/type\/downloadable\/',
        'title' => 'Admin Create Product - New Downloadable Product Validate',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Save New Downloadable Product',
        'uri' => '\/admin\/catalog\/product\/save\/set\/4\/type\/downloadable'
                . '\/back\/edit\/active_tab\/product-details\/',
        'title' => 'Admin Create Product - New Downloadable Product Save',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Create New Simple Product',
        'uri' => '\/admin\/catalog\/product\/new\/set\/4\/type\/simple\/',
        'title' => 'Admin Create Product - New Simple Product$',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Validate New Simple Product',
        'uri' => '\/admin\/catalog\/product\/validate\/set\/4\/',
        'title' => 'Admin Create Product - New Simple Product Validate',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Save New Simple Product',
        'uri' => '\/admin\/catalog\/product\/save\/set\/4\/type\/simple\/back\/edit\/active_tab\/product-details\/',
        'title' => 'Admin Create Product - New Simple Product Save',
        'scenario' => 'Admin - Create Product',
    ],
    [
        'label' => 'Admin - Open Category',
        'uri' => '\/admin\/catalog\/category\/',
        'title' => 'Admin Category Management - Landing Page',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Edit Category',
        'uri' => '\/admin\/catalog\/category\/edit\/id\/',
        'title' => 'Admin Category Management - Select parent category',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Open New Category Page',
        'uri' => '\/admin\/catalog\/category\/add\/store\/0\/parent\/',
        'title' => 'Admin Category Management - Open new category page',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Create Empty Category',
        'uri' => '\/admin\/catalog\/category\/save\/',
        'title' => 'Admin Category Management - Create empty category',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Add Products To Category',
        'uri' => '\/admin\/merchandiser\/position\/save\/',
        'title' => 'Admin Category Management - Add products',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Verify Products Added To Category',
        'uri' => '\/admin\/merchandiser\/category\/grid\/id\/',
        'title' => 'Admin Category Management - Verify products added',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Save Category With Products',
        'uri' => '\/admin\/catalog\/category\/save\/',
        'title' => 'Admin Category Management - Save category',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Move Category',
        'uri' => '\/admin\/catalog\/category\/move\/',
        'title' => 'Admin Category Management - Move category',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Delete Category',
        'uri' => '\/admin\/catalog\/category\/delete\/id\/',
        'title' => 'Admin Category Management - Delete category',
        'scenario' => 'Admin - Category Management',
    ],
    [
        'label' => 'Admin - Open Promotions Page',
        'uri' => '\/admin\/sales_rule\/promo_quote\/$',
        'title' => 'Admin Promotions Management - Landing Page',
        'scenario' => 'Admin - Promotion Rules',
    ],
    [
        'label' => 'Admin - Create New Promotion Rule',
        'uri' => '\/admin\/sales_rule\/promo_quote\/new$',
        'title' => 'Admin Promotions Management - Create New$',
        'scenario' => 'Admin - Promotion Rules',
    ],
    [
        'label' => 'Admin - Create New Condition For Promotion Rule',
        'uri' => '\/admin\/sales_rule\/promo_quote\/newConditionHtml\/form\/sales_rule_formrule_conditions_fieldset_'
                . '\/form_namespace\/sales_rule_form',
        'title' => 'Admin Promotions Management - Create New Conditional',
        'scenario' => 'Admin - Promotion Rules',
    ],
    [
        'label' => 'Admin - Save Promotion Rule',
        'uri' => '\/admin\/sales_rule\/promo_quote\/save\/',
        'title' => 'Admin Promotions Management - Save$',
        'scenario' => 'Admin - Promotion Rules',
    ],
    [
        'label' => 'API - Create Invoice',
        'uri' => '\/rest\/default\/V1\/order\/\d+\/invoice',
        'title' => 'API - Create Invoice',
        'scenario' => 'Admin - Process Orders',
    ],
    [
        'label' => 'API - Create Shipment',
        'uri' => '\/rest\/default\/V1\/order\/\d+\/ship',
        'title' => 'API - Create Shipment',
        'scenario' => 'Admin - Process Orders',
    ],
    [
        'label' => 'Admin - Open Orders Grid',
        'uri' => '\/admin\/mui\/index\/render',
        'title' => 'Admin Edit Order - Open Orders',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Open Orders Grid With Filter',
        'uri' => '\/admin\/mui\/index\/render',
        'title' => 'Admin Edit Order - Search Pending Orders Limit',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Open Orders Page',
        'uri' => '\/admin\/sales\/order\/',
        'title' => 'Admin Edit Order - Orders Page',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Open Order',
        'uri' => '\/admin\/sales\/order\/view\/order_id\/',
        'title' => 'Admin Edit Order - Open Order$',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Start Invoicing',
        'uri' => '\/admin\/sales\/order_invoice\/start\/order_id\/',
        'title' => 'Admin Edit Order - Invoice Start',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Submit Invoice',
        'uri' => '\/admin\/sales\/order_invoice\/save\/order_id\/',
        'title' => 'Admin Edit Order - Invoice Submit',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Start Credit Memo',
        'uri' => '\/admin\/sales\/order_creditmemo\/start\/order_id\/',
        'title' => 'Admin Edit Order - Credit Memo Start',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Submit Credit Memo',
        'uri' => '\/admin\/sales\/order_creditmemo\/save\/order_id\/',
        'title' => 'Admin Edit Order - Credit Memo Submit',
        'scenario' => 'Admin - Create/Process Returns',
    ],
    [
        'label' => 'Admin - Search Order By Increment Id',
        'uri' => '\/admin\/mui\/index\/render',
        'title' => 'Admin Edit Order - Search Orders$',
        'scenario' => 'Admin - Create/Process Returns',
    ],
];
