# Magento Cloud Docker

[![Docker Build Status][ico-dockerbuild]][link-dockerhub]
[![Docker Pulls][ico-downloads]][link-dockerhub]
[![Docker Stars][ico-dockerstars]][link-dockerhub]

## Welcome
Magento Cloud Docker is a package—part of the [Magento Cloud Suite](#magento-cloud-suite)—designed to develop, test, and deploy your Magento Commerce store. The Magento Cloud Docker implementation deploys Cloud projects to a local workstation so that you can develop and test your code in a simulated Cloud environment.

## Contributing to Magento Cloud Docker Code Base
You can submit issues and pull requests to extend functionality or fix potential bugs. Improvements to Magento Cloud Docker can include work such as improving the developer experience or optimizing the deployment process. If you find a bug or have a suggestion, let us know by creating a Github issue.

**Note:** This repository is not an official support channel. To receive project-specific help, submit a support ticket using the [Magento Support Portal](https://support.magento.com). Any support-related issues opened in this repository will be closed with a request to open a support ticket.

# Magento Cloud Suite
The Magento Cloud Suite includes a set of packages designed to deploy and manage Magento Commerce installations on the Cloud platform.
- The [ece-tools package](https://github.com/magento/ece-tools) - A set of scripts and tools designed to manage and deploy Cloud projects
- [Magento Cloud Components](https://github.com/magento/magento-cloud-components) package - Extended Magento Commerce core functionality for sites deployed on the Cloud platform
- [Magento Cloud Docker](https://github.com/magento/magento-cloud-docker) package - Functionality and Docker images to deploy Magento Commerce to a local Cloud environment
- [Magento Cloud Patches](https://github.com/magento/magento-cloud-patches) package - A set of patches which improve the integration of all Magento versions with Cloud environments

## Useful Resources
- [Release Notes](https://github.com/magento/magento-cloud-docker/releases)
- [Magento Cloud Docker DevDocs](https://devdocs.magento.com/guides/v2.3/cloud/docker/docker-config.html)
- [Magento Cloud Guide DevDocs](https://devdocs.magento.com/guides/v2.3/cloud/bk-cloud.html)
- [Cloud Knowledge Base and Support](https://support.magento.com)
- [Cloud Slack Channel](https://magentocommeng.slack.com) (join #cloud and #cloud-docker)
- [Docker Hub](https://hub.docker.com/r/magento/)

# Credits and License
Inspired by [meanbee/docker-magento2](https://github.com/meanbee/docker-magento2)

## License
Each Magento source file included in this distribution is licensed under OSL-3.0 license.

Please see [LICENSE.txt](https://github.com/magento/ece-tools/blob/develop/LICENSE.txt) for the full text of the [Open Software License v. 3.0 (OSL-3.0)](http://opensource.org/licenses/osl-3.0.php).

[ico-dockerbuild]: https://img.shields.io/docker/build/magento/magento-cloud-docker-php.svg?style=flat-square	
[ico-downloads]: https://img.shields.io/docker/pulls/magento/magento-cloud-docker-php.svg?style=flat-square	
[ico-dockerstars]: https://img.shields.io/docker/stars/magento/magento-cloud-docker-php.svg?style=flat-square	
[link-dockerhub]: https://hub.docker.com/r/magento/magento-cloud-docker-php