# Contributing to Magento Cloud Docker code

Use the GitHub fork & pull model contribution model to submit your code contributions to the Magento Cloud Docker codebase.
In this contribution model, you maintain your own [fork](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/working-with-forks) of the Magento Cloud Docker repository, and create a [pull request](https://help.github.com/articles/about-pull-requests/) to submit your proposed changes to the base repository. For details on the fork & pull contribution model, see the [Beginners guide](https://github.com/magento/magento2/wiki/Getting-Started).

Contributions can take the form of new features, changes to existing features, tests, bug fixes, or optimizations. You can also contribute new or updated documentation.

The Magento Cloud development team and community maintainers review all issues and contributions submitted by the developer community in first in, first out order (FIFO). During the review process, reviewers might notify a contributor to request clarification on the proposed changes.

## Prerequisites

You must have a [GitHub account](https://help.github.com/en/github/getting-started-with-github/signing-up-for-a-new-github-account) with [two-factor authentication](https://help.github.com/en/github/authenticating-to-github/configuring-two-factor-authentication) enabled to contribute to Magento repositories. We also recommend creating a [personal access token](https://help.github.com/en/articles/creating-a-personal-access-token-for-the-command-line) to use when interacting with GitHub in script from the the command line. 

## Contribution requirements

1. Contributions must adhere to the [Magento coding standards](https://devdocs.magento.com/guides/v2.3/coding-standards/bk-coding-standards.html).
2. When you submit a Pull request (PR), write a meaningful description to explain the purpose of your contribution. Comprehensive descriptions increase the chances that a pull request can be merged quickly, without requests for additional clarification. See the [Magento Cloud Docker Pull Request Template](https://github.com/magento/magento-cloud-docker/blob/develop/.github/PULL_REQUEST_TEMPLATE.md) for more information.
3. Commits must be accompanied by meaningful commit messages.
4. If your PR includes bug fixes, provide a step-by-step description of how to reproduce the bug in the pull request description.
3. If your PR includes new logic or new features, you must also submit the following information along with the pull request
   * Unit/integration test coverage
   * Proposed documentation updates: Submit developer documentation contributions to the [Magento DevDocs repository](https://github.com/magento/devdocs/blob/master/.github/CONTRIBUTING.md). Submit updates to Magento user documentation to the [Magento Merchant documentation repository](https://github.com/magento/merchdocs/blob/master/.github/CONTRIBUTING.md).
4. For larger features or changes, [open an issue](https://github.com/magento/magento-cloud-docker/issues/new) to discuss the proposed changes prior to development. Discussing the updates in advance can prevent duplicate or unnecessary effort and allow other contributors to provide input.

## Contribution process
1. Search current [listed issues](https://github.com/magento/magento-cloud-docker/issues) (open or closed) for similar proposals of intended contribution before starting work on a new contribution.
2. Review the [Contributor License Agreement](https://magento.com/legaldocuments/mca) if this is your first time contributing.
3. Create and test your work.
4. Fork the Magento Cloud repository according to the [Fork A Repository instructions](https://devdocs.magento.com/guides/v2.3/contributor-guide/contributing.html#fork) and when you are ready to send us a pull request – follow the [Create A Pull Request instructions](https://devdocs.magento.com/guides/v2.3/contributor-guide/contributing.html#pull_request).
5. After you submit the pull request, the Magento Cloud development team will review the contribution and collaborate with you as needed to incorporate your proposed changes.

## Code of Conduct

This project is released with a Contributor Code of Conduct. We expect you to agree to its terms when participating in this project.
The full text is available in the repository [Wiki](https://github.com/magento/magento2/wiki/Magento-Code-of-Conduct).

## Connecting with Community!

If you have any questions, join us in [#cloud-docker](https://magentocommeng.slack.com/messages/CJ6F3F8NS) Slack chat. If you are not on our slack, [click here](http://tinyurl.com/engcom-slack) to join.

Need to find a project? Check out the [Slack Channels](https://github.com/magento/magento2/wiki/Slack-Channels) (with listed project info) and the [Magento Community Portal](https://opensource.magento.com/).
