# Magento Cloud Components
The Magento Cloud Components module extends Magento Commerce core functionality for sites deployed on the Cloud platform.  This module contains cloud-specific functionality for use with the [ece-tools](https://github.com/magento/ece-tools) package.

## Contributing to the Magento Cloud Components Code Base
You can submit issues and pull requests to extend functionality or fix potential bugs. Improvements to Magento Cloud Components can include work such as improving the developer experience or optimizing the deployment process. If you find a bug or have a suggestion, let us know by creating a Github issue.

**Note:** This repository is not an official support channel. To receive project-specific help, submit a support ticket using the [Magento Support Portal](https://support.magento.com). Any support-related issues opened in this repository will be closed with a request to open a support ticket.

# Magento Cloud Suite
The Magento Cloud Suite includes a set of packages designed to deploy and manage Magento Commerce installations on the Cloud platform.
- The [ece-tools package](https://github.com/magento/ece-tools) - A set of scripts and tools designed to manage and deploy Cloud projects
- [Magento Cloud Components](https://github.com/magento/magento-cloud-components) package - Extended Magento Commerce core functionality for sites deployed on the Cloud platform
- [Magento Cloud Docker](https://github.com/magento/magento-cloud-docker) package - Functionality and Docker images to deploy Magento Commerce to a local Cloud environment
- [Magento Cloud Patches](https://github.com/magento/magento-cloud-patches) package - A set of patches which improve the integration of all Magento versions with Cloud environments

## Useful Resources
- [Release Notes](https://github.com/magento/magento-cloud-components/releases)
- [Magento Cloud Guide DevDocs](https://devdocs.magento.com/guides/v2.3/cloud/bk-cloud.html)
- [Cloud Knowledge Base and Support](https://support.magento.com)
- [Cloud Slack Channel](https://magentocommeng.slack.com) (join #cloud and #cloud-docker)

## License
Each Magento source file included in this distribution is licensed under OSL 3.0 or the Magento Customer Agreement.

[Open Software License (OSL 3.0)](https://opensource.org/licenses/osl-3.0.php). Please see [LICENSE_OSL.txt](LICENSE_OSL.txt) for the full text of the OSL 3.0 license or contact [engcom@adobe.com](mailto:engcom@adobe.com) for a copy.

Subject to Licensee's payment of fees and compliance with the terms and conditions of the Customer Agreement, the Customer Agreement supersedes the OSL 3.0 license for each source file. Please visit https://magento.com/legal/terms for the full text of the
Customer Agreement.
