<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\GoogleShoppingAds\Plugin\CatalogInventory\Model\Indexer\Stock;

/**
 * Binds our inventory indexer calls to the appropriate stock indexer ones
 */
class BindInventoryIndexer
{
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $inventoryIndexer;

    /**
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $inventoryIndexer
     */
    public function __construct(
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $inventoryIndexer
    ) {
        $this->inventoryIndexer = $inventoryIndexer;
    }

    /**
     * Binding execute method
     *
     * @param \Magento\Framework\Indexer\ActionInterface $subject
     * @param array $ids
     * @return mixed
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecute(\Magento\Framework\Indexer\ActionInterface $subject, $ids)
    {
        $this->inventoryIndexer->execute($ids);
        return null;
    }

    /**
     * Binding executeList method
     *
     * @param \Magento\Framework\Indexer\ActionInterface $subject
     * @param array $ids
     * @return array
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecuteList(\Magento\Framework\Indexer\ActionInterface $subject, array $ids)
    {
        $this->inventoryIndexer->executeList($ids);
        return null;
    }

    /**
     * Binding executeRow method
     *
     * @param \Magento\Framework\Indexer\ActionInterface $subject
     * @param int $id
     * @return mixed
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecuteRow(\Magento\Framework\Indexer\ActionInterface $subject, $id)
    {
        $this->inventoryIndexer->executeRow($id);
        return null;
    }
}
