<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\GoogleShoppingAds\Plugin\Catalog\Model\Indexer\Product\Price;

/**
 * Binds our price indexer calls to the appropriate price indexer ones
 */
class BindPriceIndexer
{
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $priceIndexer;

    /**
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $priceIndexer
     */
    public function __construct(
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $priceIndexer
    ) {
        $this->priceIndexer = $priceIndexer;
    }

    /**
     * Binding execute method
     *
     * @param \Magento\Framework\Indexer\ActionInterface $subject
     * @param array $ids
     * @return void
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecute(\Magento\Framework\Indexer\ActionInterface $subject, $ids)
    {
        $this->priceIndexer->execute($ids);
    }

    /**
     * Binding executeList method
     *
     * @param \Magento\Framework\Indexer\ActionInterface $subject
     * @param array $ids
     * @return void
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecuteList(\Magento\Framework\Indexer\ActionInterface $subject, array $ids)
    {
        $this->priceIndexer->executeList($ids);
    }

    /**
     * Binding executeRow method
     *
     * @param \Magento\Framework\Indexer\ActionInterface $subject
     * @param int $id
     * @return void
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeExecuteRow(\Magento\Framework\Indexer\ActionInterface $subject, $id)
    {
        $this->priceIndexer->executeRow($id);
    }
}
