<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\GoogleShoppingAds\Plugin\Catalog\Controller\Adminhtml\Product\Action\Attribute\Save;

/**
 * Binds our attribute indexer calls to the appropriate EAV indexer ones
 */
class BindAttributeIndexer
{
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $attributeIndexer;

    /**
     * @var \Magento\Catalog\Helper\Product\Edit\Action\Attribute
     */
    private $attribute;

    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\RemoveIndexer
     */
    private $removeIndexer;
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $priceIndexer;
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $inventoryIndexer;

    /**
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $attributeIndexer
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $priceIndexer
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $inventoryIndexer
     * @param \Magento\GoogleShoppingAds\Model\Indexer\RemoveIndexer $removeIndexer
     * @param \Magento\Catalog\Helper\Product\Edit\Action\Attribute $attribute
     */
    public function __construct(
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $attributeIndexer,
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $priceIndexer,
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $inventoryIndexer,
        \Magento\GoogleShoppingAds\Model\Indexer\RemoveIndexer $removeIndexer,
        \Magento\Catalog\Helper\Product\Edit\Action\Attribute $attribute
    ) {
        $this->attributeIndexer = $attributeIndexer;
        $this->attribute = $attribute;
        $this->removeIndexer = $removeIndexer;
        $this->priceIndexer = $priceIndexer;
        $this->inventoryIndexer = $inventoryIndexer;
    }

    /**
     * Execute attributes indexation process for edited products
     *
     * @param \Magento\Catalog\Controller\Adminhtml\Product\Action\Attribute\Save $subject
     * @param \Magento\Backend\Model\View\Result\Redirect $result
     * @return \Magento\Backend\Model\View\Result\Redirect
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterExecute(\Magento\Catalog\Controller\Adminhtml\Product\Action\Attribute\Save $subject, $result)
    {
        $ids = $this->attribute->getProductIds();
        $this->removeIndexer->execute($ids);
        $this->attributeIndexer->execute($ids);
        $this->inventoryIndexer->execute($ids);
        $this->priceIndexer->execute($ids);
        return $result;
    }
}
