<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\GoogleShoppingAds\Plugin\Catalog\Controller\Adminhtml\Product\MassStatus;

/**
 * Binds our remove indexer calls to the mass delete controller
 */
class BindIndexers
{
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\RemoveIndexer
     */
    private $removeIndexer;
    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    private $filter;
    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    private $collectionFactory;
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $attributeIndexer;
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $priceIndexer;
    /**
     * @var \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer
     */
    private $inventoryIndexer;

    /**
     * @param \Magento\GoogleShoppingAds\Model\Indexer\RemoveIndexer $removeIndexer
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $attributeIndexer
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $priceIndexer
     * @param \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $inventoryIndexer
     * @param \Magento\Ui\Component\MassAction\Filter $filter
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
     */
    public function __construct(
        \Magento\GoogleShoppingAds\Model\Indexer\RemoveIndexer $removeIndexer,
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $attributeIndexer,
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $priceIndexer,
        \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer $inventoryIndexer,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $collectionFactory
    ) {
        $this->removeIndexer = $removeIndexer;
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->attributeIndexer = $attributeIndexer;
        $this->priceIndexer = $priceIndexer;
        $this->inventoryIndexer = $inventoryIndexer;
    }

    /**
     * Execute remove indexation process for deleted products
     *
     * @param \Magento\Catalog\Controller\Adminhtml\Product\MassStatus $subject
     * @param callable $proceed
     * @return \Magento\Backend\Model\View\Result\Redirect
     * @throws \Magento\Framework\Exception\LocalizedException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundExecute(\Magento\Catalog\Controller\Adminhtml\Product\MassStatus $subject, callable $proceed)
    {
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $ids = $collection->getAllIds();
        $result = $proceed();
        $this->removeIndexer->execute($ids);
        $this->attributeIndexer->execute($ids);
        $this->inventoryIndexer->execute($ids);
        $this->priceIndexer->execute($ids);
        return $result;
    }
}
