<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\GoogleShoppingAds\Controller\Adminhtml\Index;

/**
 * Controller responsible for invalidating product feed indexes
 */
class InvalidateIndexes extends \Magento\Backend\App\AbstractAction
{
    /**
     * @var \Magento\Framework\Indexer\IndexerRegistry
     */
    private $indexerRegistry;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Indexer\IndexerRegistry $indexerRegistry
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Indexer\IndexerRegistry $indexerRegistry
    ) {
        parent::__construct($context);
        $this->indexerRegistry = $indexerRegistry;
    }

    /**
     * @inheritdoc
     */
    public function execute()
    {
        $indexerIds = [
            \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer::INDEXER_ATTRIBUTE_ID,
            \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer::INDEXER_PRICE_ID,
            \Magento\GoogleShoppingAds\Model\Indexer\FeedIndexer::INDEXER_INVENTORY_ID
        ];
        foreach ($indexerIds as $indexerId) {
            $indexer = $this->indexerRegistry->get($indexerId);
            if (!$indexer->isScheduled()) {
                $indexer->invalidate();
            }
        }
        $result = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_RAW);
        return $result;
    }

    /**
     * Check is user can access to Google Advertising Channels Connector
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_GoogleShoppingAds::scconnector_google');
    }
}
