<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\Framework\Data\Test\Unit\Argument\Interpreter;

use Magento\Framework\Data\Argument\Interpreter\Constant;
use PHPUnit\Framework\TestCase;

class ConstantTest extends TestCase
{
    /**
     * @var Constant
     */
    private $object;

    protected function setUp(): void
    {
        $this->object = new Constant();
    }

    public function testEvaluate()
    {
        // it is defined in framework/bootstrap.php
        $this->assertEquals(TESTS_TEMP_DIR, $this->object->evaluate(['value' => 'TESTS_TEMP_DIR']));
    }

    /**
     * @dataProvider evaluateBadValueDataProvider
     */
    public function testEvaluateBadValue($value)
    {
        $this->expectException('InvalidArgumentException');
        $this->expectExceptionMessage('Constant "'. $value['value'] .'" is not defined.');
        $this->object->evaluate($value);
    }

    /**
     * @return array
     */
    public static function evaluateBadValueDataProvider()
    {
        return [
            [['value' => 'KNOWINGLY_UNDEFINED_CONSTANT']],
            [['value' => '']],
        ];
    }
}
