<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\MagentoCloud\Command\Build;

use Magento\MagentoCloud\Cli;
use Magento\MagentoCloud\Scenario\Exception\ProcessorException;
use Magento\MagentoCloud\Scenario\Processor;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * CLI command for transfer data generated by build:generate command ot init directory.
 *
 * @api
 */
class Transfer extends Command
{
    public const NAME = 'build:transfer';

    /**
     * @var Processor
     */
    private $processor;

    /**
     * @param Processor $processor
     */
    public function __construct(Processor $processor)
    {
        $this->processor = $processor;

        parent::__construct();
    }

    /**
     * @inheritdoc
     */
    protected function configure(): void
    {
        $this->setName(static::NAME)
            ->setDescription('Transfers generated files into init directory.');

        parent::configure();
    }

    /**
     * {@inheritdoc}
     *
     * @throws ProcessorException
     */
    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->processor->execute([
            'scenario/build/transfer.xml'
        ]);

        return Cli::SUCCESS;
    }
}
