<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Klarna\Kp\Observer;

use Klarna\Kp\Api\QuoteInterface;
use Klarna\Kp\Api\QuoteRepositoryInterface;
use Magento\Framework\DataObjectFactory;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Payment\Observer\AbstractDataAssignObserver;
use Magento\Quote\Api\Data\PaymentInterface;
use Psr\Log\LoggerInterface;

/**
 * Class AssignData
 *
 * @package Klarna\Kp\Observer
 */
class AssignData extends AbstractDataAssignObserver
{
    /**
     * @var QuoteRepositoryInterface
     */
    private $klarnaQuoteRepository;
    /**
     * @var LoggerInterface
     */
    private $log;
    /**
     * @var DataObjectFactory
     */
    private $dataObjectFactory;

    /**
     * AssignData constructor.
     *
     * @param QuoteRepositoryInterface $klarnaQuoteRepository
     * @param LoggerInterface          $log
     * @param DataObjectFactory        $dataObjectFactory
     */
    public function __construct(
        QuoteRepositoryInterface $klarnaQuoteRepository,
        LoggerInterface $log,
        DataObjectFactory $dataObjectFactory
    ) {
        $this->klarnaQuoteRepository = $klarnaQuoteRepository;
        $this->log = $log;
        $this->dataObjectFactory = $dataObjectFactory;
    }

    /**
     * Observer
     *
     * @param Observer $observer
     * @return void
     * @throws LocalizedException
     */
    public function execute(Observer $observer)
    {
        $method = $this->readMethodArgument($observer);
        if (false === strpos($method->getCode(), 'klarna_')) {
            return;
        }

        $data = $this->readDataArgument($observer);
        $additionalData = $data->getData(PaymentInterface::KEY_ADDITIONAL_DATA);
        if (!is_array($additionalData)) {
            return;
        }

        $additionalData = $this->dataObjectFactory->create(['data' => $additionalData]);

        $payment = $this->readPaymentModelArgument($observer);
        $quote = $payment->getQuote();
        try {
            /** @var QuoteInterface $klarnaQuote */
            $klarnaQuote = $this->klarnaQuoteRepository->getActiveByQuote($quote);
            $klarnaQuote->setAuthorizationToken($additionalData->getData('authorization_token'));
            $this->klarnaQuoteRepository->save($klarnaQuote);
        } catch (NoSuchEntityException $npe) {
            $data = ['klarna_id' => $additionalData->getData('authorization_token')];
            $this->log->error($npe, $data);
        }
    }
}
