/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */
define(
    [
        'ko'
    ],
    function (ko) {
        'use strict';
        var client_token = window.checkoutConfig.payment.klarna_kp.client_token;
        var message = window.checkoutConfig.payment.klarna_kp.message;
        var authorization_token = ko.observable(window.checkoutConfig.payment.klarna_kp.authorization_token);
        var prescreen_enabled = window.checkoutConfig.payment.klarna_kp.prescreen;
        var debug = window.checkoutConfig.payment.klarna_kp.debug;
        var success = window.checkoutConfig.payment.klarna_kp.success;
        var hasErrors = ko.observable(false);
        var iframeEnabled = ko.observable(true);
        var available_methods = window.checkoutConfig.payment.klarna_kp.available_methods;
        return {
            hasErrors: hasErrors,
            iframeEnabled: iframeEnabled,
            debug: debug,
            client_token: client_token,
            message: message,
            success: success,
            authorization_token: authorization_token,
            prescreen_enabled: prescreen_enabled,
            available_methods: available_methods
        };
    });
