<?php
/**
 * This file is part of the Klarna KP module
 *
 * (c) Klarna Bank AB (publ)
 *
 * For the full copyright and license information, please view the NOTICE
 * and LICENSE files that were distributed with this source code.
 */

namespace Klarna\Kp\Gateway\Validator;

use Klarna\Core\Helper\ConfigHelper;
use Klarna\Kp\Model\Session;
use Magento\Payment\Gateway\Validator\AbstractValidator;
use Magento\Payment\Gateway\Validator\ResultInterface;
use Magento\Payment\Gateway\Validator\ResultInterfaceFactory;

/**
 * Class SessionValidator
 */
class SessionValidator extends AbstractValidator
{
    /**
     * Session
     *
     * @var Session
     */
    private $session;
    /**
     * @var ConfigHelper
     */
    private $helper;

    /**
     * Constructor
     *
     * @param ResultInterfaceFactory $resultFactory
     * @param Session                $session
     * @param ConfigHelper           $helper
     */
    public function __construct(
        ResultInterfaceFactory $resultFactory,
        Session $session,
        ConfigHelper $helper
    ) {
        $this->session = $session;
        parent::__construct($resultFactory);
        $this->helper = $helper;
    }

    /**
     * Validate
     *
     * @param bool  $isValid
     * @param array $fails
     * @return ResultInterface
     */
    public function validate(array $validationSubject)
    {
        $store = $this->session->getQuote()->getStore();
        if (!$this->helper->getPaymentConfigFlag('active', $store)) {
            return $this->createResult(false, [__('Klarna Payments is not enabled')]);
        }
        $merchant_id = $this->helper->getApiConfig('merchant_id', $store);
        $secret = $this->helper->getApiConfig('secret', $store);
        if (empty($merchant_id) || empty($secret)) {
            return $this->createResult(false, [__('Klarna API Credentials are required')]);
        }

        return $this->createResult(true);
    }
}
